/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.framework.ui.html;

import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import org.molgenis.framework.ui.html.HtmlInputException;
import org.molgenis.framework.ui.html.OptionInput;
import org.molgenis.framework.ui.html.StringInput;
import org.molgenis.util.ValueLabel;
import org.molgenis.util.tuple.Tuple;

public class CheckboxInput
extends OptionInput<List<String>> {
    public static final String VALUES = "values";
    private String onchange = null;

    public CheckboxInput(String name, String label, String description, Vector<ValueLabel> options, List<String> value) {
        super(name, value);
        super.setLabel(label);
        super.setDescription(description);
        super.setOptions(options);
        this.setReadonly(false);
    }

    public CheckboxInput(String name, List<String> options, List<String> optionLabels, String label, List<String> value, boolean nillable, boolean readonly) {
        super(name, value);
        if (optionLabels != null && optionLabels.size() > 0 && optionLabels.size() != options.size()) {
            throw new IllegalArgumentException("optionLabels, if set, must be of same size as options");
        }
        ArrayList<ValueLabel> result = new ArrayList<ValueLabel>();
        if (optionLabels != null && optionLabels.size() == optionLabels.size()) {
            for (int i = 0; i < options.size(); ++i) {
                result.add(new ValueLabel(options.get(i), optionLabels.get(i)));
            }
        } else {
            for (String option : options) {
                result.add(new ValueLabel(option, option));
            }
        }
        this.setLabel(label);
        this.setNillable(nillable);
        this.setReadonly(readonly);
    }

    public CheckboxInput(Tuple properties) throws HtmlInputException {
        super(properties);
        if (!properties.isNull("value")) {
            this.setValue(properties.getList("value"));
        }
        if (!properties.isNull(VALUES)) {
            this.setValue(properties.getList(VALUES));
        }
    }

    protected CheckboxInput() {
    }

    public String getOnchange() {
        return this.onchange;
    }

    public void setOnchange(String onchange) {
        this.onchange = onchange;
    }

    @Override
    public String toHtml() {
        String onchange;
        if (this.isHidden()) {
            StringInput input = new StringInput(this.getName(), this.getValue());
            input.setHidden(true);
            return input.toHtml();
        }
        StringBuffer optionString = new StringBuffer("");
        String readonly = this.isReadonly() ? " class=\"readonly\" readonly " : "";
        String checked = "";
        String string = onchange = this.onchange != null ? " onchange=\"" + this.onchange + "\"" : "";
        if (!this.getOptions().isEmpty()) {
            for (ValueLabel option : this.getOptions()) {
                if (this.getObject() != null) {
                    checked = ((List)this.getObject()).contains(option.getValue().toString()) ? " checked " : "";
                }
                optionString.append("<input id=\"" + this.getId() + "\" type=\"checkbox\" " + onchange + readonly + checked + " name=\"" + this.getName() + "\" value=\"" + option.getValue() + "\">" + option.getLabel() + "<br />\n");
            }
        } else {
            if (this.getObject() != null) {
                checked = ((Vector)this.getObject()).contains(this.getName()) ? " checked " : "";
            }
            optionString.append("<input id=\"" + this.getId() + "\" type=\"checkbox\" " + onchange + readonly + checked + " name=\"" + this.getName() + "\">" + this.getLabel());
        }
        return optionString.toString();
    }

    @Override
    public String getValue() {
        StringBuilder valueBuilder = new StringBuilder();
        for (ValueLabel i : this.getOptions()) {
            if (!((Vector)this.getObject()).contains(i.getValue())) continue;
            valueBuilder.append(i.getLabel()).append(", ");
        }
        if (valueBuilder.length() > 2) {
            return valueBuilder.substring(0, valueBuilder.length() - 2);
        }
        return valueBuilder.toString();
    }

    @Override
    public String toHtml(Tuple p) throws HtmlInputException {
        return new CheckboxInput(p).render();
    }
}

