/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.framework.ui.html;

import java.text.ParseException;
import org.apache.commons.lang3.StringUtils;
import org.molgenis.framework.server.services.MolgenisGuiService;
import org.molgenis.framework.ui.html.HtmlElement;
import org.molgenis.framework.ui.html.HtmlInput;
import org.molgenis.framework.ui.html.HtmlInputException;
import org.molgenis.util.tuple.Tuple;

public class ActionInput
extends HtmlInput<Object> {
    private int width = 0;
    private String icon;
    private int iconHeight = 16;
    private int iconWidth = 16;
    private Type type;
    private String JavaScriptAction;
    private String buttonValue;
    private boolean showLabel = true;

    public ActionInput(String name) {
        this(name, Type.CUSTOM);
    }

    public ActionInput(String name, String label) {
        this(name, Type.CUSTOM);
        this.setLabel(label);
        this.setButtonValue(label);
    }

    public ActionInput(String name, String label, String buttonValue) {
        this(name, label);
        this.setTooltip(buttonValue);
        this.setButtonValue(buttonValue);
    }

    public ActionInput(String name, Type type) {
        super(name, type);
        this.setType(type);
        this.setLabel(type.toString());
        this.setTooltip(type.toString());
        this.setButtonValue(name);
    }

    public ActionInput(Type select_target) {
        this(select_target.toString());
        this.setLabel(select_target.toString().replace("_", " "));
    }

    public ActionInput(Tuple t) throws HtmlInputException {
        super(t);
        this.type = Type.CUSTOM;
    }

    public ActionInput() {
    }

    @Override
    public String toHtml() {
        if (this.uiToolkit == HtmlElement.UiToolkit.ORIGINAL || this.getIcon() != null && this.buttonValue.equals("")) {
            return this.renderDefault();
        }
        if (this.uiToolkit == HtmlElement.UiToolkit.JQUERY) {
            return this.renderJquery();
        }
        return "ERROR";
    }

    public String renderDefault() {
        StringBuffer input = new StringBuffer("");
        if (this.getIcon() != null) {
            input.append("<img class=\"edit_button\" src=\"" + this.getIcon() + "\" alt=\"" + this.getLabel() + "\" onclick=\"" + this.getJavaScriptAction() + " $(this).closest('form').submit();\" title=\"" + this.getTooltip() + "\" id=\"" + this.getId() + "\" style=\"" + this.getStyle() + "\" " + this.tabIndex + " />");
        } else {
            input.append("<input type=\"submit\" onclick=\"" + this.getJavaScriptAction() + "\" title=\"" + this.getTooltip() + "\" id=\"" + this.getId() + "\"" + "value=\"" + this.getButtonValue() + "\" style=\"" + this.getStyle() + "\" " + this.tabIndex + " />");
        }
        return input.toString();
    }

    public String getIcon() {
        return this.icon;
    }

    public void setIcon(String icon) {
        this.icon = icon;
    }

    public String getJavaScriptAction() {
        if (this.JavaScriptAction == null) {
            if (this.type == Type.SAVE) {
                StringBuffer jScript = new StringBuffer();
                if (this.uiToolkit == HtmlElement.UiToolkit.ORIGINAL) {
                    jScript.append("if( validateForm(document.forms[0],molgenis_required) ) { if( window.opener.name == '' ){ window.opener.name = 'molgenis'+new Date().getTime();} document.forms[0].target = window.opener.name; document.forms[0].submit(); window.close();} else return false;");
                } else {
                    jScript.append("if( $(this.form).valid() && validateForm(document.forms[0],molgenis_required) ) { if( window.opener.name == '' ){ window.opener.name = 'molgenis'+new Date().getTime();} document.forms[0].__show.value = ''; document.forms[0].__action.value ='" + this.getValue() + "'; document.forms[0].target = window.opener.name; document.forms[0].submit(); window.close();} return false;");
                }
                return jScript.toString();
            }
            if (this.type == Type.NEXT) {
                StringBuffer jScript = new StringBuffer();
                jScript.append("if( validateForm(document.forms[0],molgenis_required) ) { if( window.opener.name == '' ){ window.opener.name = 'molgenis_" + MolgenisGuiService.getNewWindowId() + "';} document.forms[0].__show.value='popup'; document.forms[0].submit();} else return false;");
                return jScript.toString();
            }
            if (this.type == Type.CLOSE) {
                return "window.close();";
            }
            if (this.type == Type.CUSTOM) {
                return "$(this).closest('form').find('input[name=__action]').val('" + this.getName() + "');";
            }
        }
        return this.JavaScriptAction;
    }

    public void setJavaScriptAction(String javaScriptAction) {
        this.JavaScriptAction = javaScriptAction;
    }

    public Type getType() {
        return this.type;
    }

    public void setType(Type type) {
        this.type = type;
    }

    @Override
    public String getLabel() {
        return "&nbsp;";
    }

    public String getButtonValue() {
        if (this.buttonValue == null) {
            return this.getLabel();
        }
        return this.buttonValue;
    }

    public void setButtonValue(String buttonValue) {
        this.buttonValue = buttonValue;
    }

    public String getIconHtml() {
        return "<img src=\"" + this.getIcon() + "\"/>";
    }

    public String toIconHtml() {
        return "<img class=\"edit_button\" src=\"" + this.getIcon() + "\" title=\"" + this.getLabel() + "\" onclick=\"" + this.getJavaScriptAction() + "\">";
    }

    public String toLinkHtml() {
        return "<a title=\"" + this.getDescription() + "\" onclick=\"" + this.getJavaScriptAction() + "\">" + this.getLabel() + "</a>";
    }

    @Override
    public String toHtml(Tuple params) throws ParseException, HtmlInputException {
        return new ActionInput(params).render();
    }

    @Override
    public String getCustomHtmlHeaders() {
        return "";
    }

    private String renderJquery() {
        String icons = "";
        String iconClassCss = "";
        if (this.getIcon() != null) {
            String iconClass = this.getIcon().replace("/", "-").replace(".png", "").replace(".jpg", "");
            iconClassCss = "<style type=\"text/css\">";
            iconClassCss = iconClassCss + "." + iconClass + " { background-image: url(" + this.getIcon() + ") !important; ";
            iconClassCss = iconClassCss + "</style>";
            icons = icons + "{ icons: {primary:'" + iconClass + "', secondary: null}" + (this.isShowLabel() ? "}" : ", text: false }");
        }
        String result = iconClassCss + "<button type=\"submit\" class=\"btn btn-small\" id=\"" + this.getId() + "\" onclick=\"" + this.getJavaScriptAction() + "\" />" + StringUtils.capitalize((String)this.getButtonValue()) + "</button>";
        return result;
    }

    public boolean showLabel() {
        return this.showLabel;
    }

    public boolean isShowLabel() {
        return this.showLabel;
    }

    public void setShowLabel(boolean showLabel) {
        this.showLabel = showLabel;
    }

    public void setIconHeight(int iconHeight) {
        this.iconHeight = iconHeight;
    }

    public int getIconHeight() {
        return this.iconHeight;
    }

    public void setIconWidth(int iconWidth) {
        this.iconWidth = iconWidth;
    }

    public int getIconWidth() {
        return this.iconWidth;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public static enum Type {
        SAVE("Save"),
        CANCEL("Cancel"),
        NEXT("Next"),
        CLOSE("Close"),
        AUTOCLOSE("Autoclose"),
        CUSTOM("Set Label, Tooltip, and JavaScriptAction yourself");

        public final String tag;

        private Type(String tag) {
            this.tag = tag;
        }

        public String toString() {
            return this.tag;
        }
    }
}

