/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.framework.ui.commands;

import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.molgenis.framework.db.Database;
import org.molgenis.framework.db.DatabaseException;
import org.molgenis.framework.db.Query;
import org.molgenis.framework.server.MolgenisRequest;
import org.molgenis.framework.ui.FormController;
import org.molgenis.framework.ui.FormModel;
import org.molgenis.framework.ui.ScreenController;
import org.molgenis.framework.ui.ScreenMessage;
import org.molgenis.framework.ui.ScreenModel;
import org.molgenis.framework.ui.commands.EditSelectedInput;
import org.molgenis.framework.ui.commands.SimpleCommand;
import org.molgenis.framework.ui.html.ActionInput;
import org.molgenis.framework.ui.html.HiddenInput;
import org.molgenis.framework.ui.html.HtmlInput;
import org.molgenis.framework.ui.html.Paragraph;
import org.molgenis.util.Entity;
import org.molgenis.util.tuple.KeyValueTuple;

public class EditSelectedCommand
extends SimpleCommand {
    private static final long serialVersionUID = -2996595009523144519L;
    private static final Logger logger = Logger.getLogger(EditSelectedCommand.class);
    private List<?> selectedIds = new ArrayList();

    public EditSelectedCommand(String name, ScreenController<?> parentScreen) {
        super(name, parentScreen);
        this.setLabel("Update selected");
        this.setIcon("img/update.gif");
        this.setDialog(true);
        this.setMenu("Edit");
    }

    @Override
    public boolean isVisible() {
        FormModel<?> view = this.getFormScreen();
        return !view.isReadonly() && view.getMode().equals((Object)FormModel.Mode.LIST_VIEW);
    }

    @Override
    public ScreenModel.Show handleRequest(Database db, MolgenisRequest request, OutputStream out) throws Exception {
        logger.debug((Object)this.getName());
        if (request.getString("__show") == null) {
            FormModel<?> view = this.getFormScreen();
            List<String> idList = request.getList("massUpdate");
            for (String id : idList) {
                logger.info((Object)("mass updating id: " + id));
            }
            ScreenMessage msg = null;
            KeyValueTuple tuple = new KeyValueTuple();
            for (HtmlInput<?> input : this.getFormScreen().getNewRecordForm().getInputs()) {
                if (request.isNull("use_" + input.getName())) continue;
                tuple.set(input.getName(), request.get(input.getName()));
            }
            int row = 0;
            try {
                Query q = db.query(((FormController)view.getController()).getEntityClass()).in(view.create().getIdField(), idList);
                List entities = q.find();
                db.beginTx();
                for (Entity e : entities) {
                    ++row;
                    e.set(tuple, false);
                    db.update(e);
                }
                db.commitTx();
                msg = new ScreenMessage("MASS UPDATE SUCCESS: updated " + entities.size() + " rows", null, true);
            }
            catch (Exception e) {
                try {
                    db.rollbackTx();
                }
                catch (DatabaseException e1) {
                    logger.error((Object)("doMassUpdate() Should never happen: " + e1));
                    e1.printStackTrace();
                }
                msg = new ScreenMessage("MASS UPDATE FAILED on item '" + row + "': " + e, null, false);
            }
            view.getMessages().add(msg);
        } else {
            this.selectedIds = request.getList("massUpdate");
        }
        return ScreenModel.Show.SHOW_MAIN;
    }

    @Override
    public List<ActionInput> getActions() {
        ArrayList<ActionInput> inputs = new ArrayList<ActionInput>();
        ActionInput submit = new ActionInput("Update", ActionInput.Type.SAVE);
        submit.setValue(this.getName());
        submit.setIcon("img/save.png");
        submit.setDescription("Save the changes.");
        inputs.add(submit);
        ActionInput cancel = new ActionInput("Cancel", ActionInput.Type.CLOSE);
        cancel.setIcon("img/cancel.png");
        submit.setDescription("Cancel the changes.");
        inputs.add(cancel);
        return inputs;
    }

    @Override
    public List<HtmlInput<?>> getInputs() throws DatabaseException {
        ArrayList inputs = new ArrayList();
        if (this.selectedIds == null || this.selectedIds.size() == 0) {
            Paragraph t = new Paragraph("No records were selected for updating.");
            t.setDescription("Error.");
            inputs.add(t);
            return inputs;
        }
        Paragraph t = new Paragraph("Selected ids:" + this.selectedIds.toString());
        t.setDescription("The IDs you have selected for updating.");
        inputs.add(t);
        for (Object obj : this.selectedIds) {
            HiddenInput h = new HiddenInput("massUpdate", obj);
            h.setDescription("Hidden input");
            inputs.add(h);
        }
        for (HtmlInput htmlInput : this.getFormScreen().getNewRecordForm().getInputs()) {
            if (htmlInput.isHidden() || htmlInput.isReadonly()) continue;
            EditSelectedInput e = new EditSelectedInput(htmlInput);
            e.setDescription("EditSelectedInput");
            inputs.add(e);
        }
        return inputs;
    }
}

