/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.framework.ui.commands;

import java.io.OutputStream;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.molgenis.framework.db.Database;
import org.molgenis.framework.db.DatabaseException;
import org.molgenis.framework.db.EntitiesImporter;
import org.molgenis.framework.db.EntityImportReport;
import org.molgenis.framework.server.MolgenisRequest;
import org.molgenis.framework.ui.ScreenController;
import org.molgenis.framework.ui.ScreenMessage;
import org.molgenis.framework.ui.ScreenModel;
import org.molgenis.framework.ui.commands.SimpleCommand;
import org.molgenis.framework.ui.html.ActionInput;
import org.molgenis.framework.ui.html.HtmlInput;
import org.molgenis.framework.ui.html.TextInput;
import org.molgenis.io.csv.CsvReader;
import org.molgenis.util.ApplicationUtil;
import org.molgenis.util.Entity;

public class AddBatchCommand<E extends Entity>
extends SimpleCommand {
    private static final long serialVersionUID = -4067952586340535730L;
    private static final Logger logger = Logger.getLogger(AddBatchCommand.class);
    private EntitiesImporter entitiesImporter;

    public AddBatchCommand(String name, ScreenController<?> owner) {
        super(name, owner);
        this.setLabel("Add in batch/upload CSV");
        this.setIcon("img/upload.png");
        this.setDialog(true);
        this.setMenu("File");
        this.entitiesImporter = ApplicationUtil.getEntitiesImporter();
    }

    @Override
    public List<ActionInput> getActions() {
        ArrayList<ActionInput> inputs = new ArrayList<ActionInput>();
        ActionInput submit = new ActionInput("Add", ActionInput.Type.SAVE);
        submit.setValue("upload_csv");
        submit.setIcon("img/save.png");
        submit.setDescription("Store the data");
        inputs.add(submit);
        ActionInput cancel = new ActionInput("Cancel", ActionInput.Type.CLOSE);
        cancel.setIcon("img/cancel.png");
        cancel.setDescription("Cancel adding data");
        inputs.add(cancel);
        return inputs;
    }

    @Override
    public List<HtmlInput<?>> getInputs() throws DatabaseException {
        List<HtmlInput<?>> inputs = this.getFormScreen().getNewRecordForm().getInputs();
        for (HtmlInput<?> i : inputs) {
            i.setNillable(true);
        }
        TextInput csvInput = new TextInput("__csvdata", "put here your data in comma-separated format.");
        csvInput.setLabel("CSV data");
        csvInput.setTooltip("put here your data in comma-separated format.");
        csvInput.setDescription("Put your CSV data here.");
        inputs.add(csvInput);
        return inputs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ScreenModel.Show handleRequest(Database db, MolgenisRequest request, OutputStream downloadStream) throws Exception {
        logger.debug((Object)this.getName());
        if (request.getString("__show") == null) {
            ScreenMessage msg = null;
            try {
                CsvReader csvReader = new CsvReader(new StringReader(request.getString("__csvdata")));
                String entityName = this.getFormScreen().getEntityClass().getSimpleName();
                EntityImportReport importReport = null;
                try {
                    importReport = this.entitiesImporter.importEntities(csvReader, entityName, Database.DatabaseAction.ADD);
                }
                finally {
                    csvReader.close();
                }
                msg = new ScreenMessage("CSV UPLOAD SUCCESS: added " + importReport.getNrImported() + " rows", null, true);
                logger.debug((Object)("CSV UPLOAD SUCCESS: added " + importReport.getNrImported() + " rows"));
                this.getFormScreen().getPager().resetFilters();
                this.getFormScreen().getPager().last(db);
            }
            catch (Exception e) {
                e.printStackTrace();
                msg = new ScreenMessage("CSV UPLOAD FAILED: " + e.getMessage(), null, false);
                logger.error((Object)("CSV UPLOAD FAILED: " + e.getMessage()));
            }
            this.getFormScreen().getMessages().add(msg);
        }
        return ScreenModel.Show.SHOW_MAIN;
    }

    @Override
    public boolean isVisible() {
        return !this.getFormScreen().isReadonly();
    }
}

