/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.framework.ui;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.molgenis.framework.ui.ScreenController;
import org.molgenis.framework.ui.ScreenMessage;
import org.molgenis.framework.ui.ScreenModel;
import org.molgenis.framework.ui.commands.CommandMenu;
import org.molgenis.framework.ui.commands.ScreenCommand;
import org.molgenis.framework.ui.html.HtmlInputException;

public abstract class SimpleScreenModel
implements ScreenModel,
Serializable {
    private static final long serialVersionUID = 3764151203967037515L;
    protected static final Logger logger = Logger.getLogger(SimpleScreenModel.class);
    public static final String INPUT_TARGET = "__target";
    public static final String INPUT_ACTION = "__action";
    private String label;
    private ScreenController<?> controller;
    private Map<String, CommandMenu> menubar = new LinkedHashMap<String, CommandMenu>();
    private Vector<ScreenMessage> messages = new Vector();
    private boolean visible = true;

    public SimpleScreenModel(ScreenController<?> controller) {
        this.controller = controller;
        this.reset();
    }

    @Override
    public void reset() {
    }

    @Override
    public String render() throws HtmlInputException {
        String result = this.getController().render();
        if (result == null) {
            System.out.println("error with render of " + this);
        }
        return this.getController().render();
    }

    @Override
    public String getName() {
        return this.getController().getName();
    }

    @Override
    public void setLabel(String label) {
        this.label = label;
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    public ScreenController<? extends ScreenModel> getController() {
        return this.controller;
    }

    @Override
    public void setController(ScreenController<? extends ScreenModel> controller) {
        this.controller = controller;
    }

    public void addCommand(ScreenCommand command) {
        command.setController(this.getController());
        command.setTargetController(this.getController().getName());
        if (this.getCommand(command.getName()) != null) {
            logger.warn((Object)("command with name '" + command.getName() + "' already exists; replaced"));
        }
        if (!this.menubar.containsKey(command.getMenu())) {
            this.menubar.put(command.getMenu(), new CommandMenu(command.getMenu(), this.getController(), command.getMenu(), "", ""));
        }
        this.menubar.get(command.getMenu()).addCommand(command);
        logger.debug((Object)("added action " + command.getName()));
    }

    public ScreenCommand getCommand(String commandID) {
        for (CommandMenu menu : this.menubar.values()) {
            if (menu.getCommand(commandID) == null) continue;
            return menu.getCommand(commandID);
        }
        return null;
    }

    public Collection<CommandMenu> getMenus() {
        return this.menubar.values();
    }

    @Override
    public void setMessages(Vector<ScreenMessage> messages) {
        this.messages = messages;
    }

    @Override
    public void setMessages(ScreenMessage ... messages) {
        this.messages = new Vector<ScreenMessage>(Arrays.asList(messages));
    }

    @Override
    public Vector<ScreenMessage> getMessages() {
        return this.messages;
    }

    @Override
    public ScreenModel getSelected() {
        return this.getController().getSelected();
    }

    public List<ScreenModel> getChildren() {
        ArrayList<ScreenModel> result = new ArrayList<ScreenModel>();
        for (ScreenController childController : this.getController().getChildren()) {
            result.add((ScreenModel)childController.getModel());
        }
        return result;
    }

    @Override
    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    @Override
    public void setSuccess(String message) {
        this.setMessages(new ScreenMessage(message, true));
    }

    @Override
    public void setError(String message) {
        this.setMessages(new ScreenMessage(message, false));
    }

    public String getCustomHtmlHeaders() {
        return null;
    }

    public String getCustomHtmlBodyOnLoad() {
        return null;
    }
}

