/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.framework.ui;

import java.io.File;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.molgenis.framework.db.Database;
import org.molgenis.framework.db.DatabaseException;
import org.molgenis.framework.db.EntitiesImporter;
import org.molgenis.framework.db.QueryRule;
import org.molgenis.framework.db.paging.DatabasePager;
import org.molgenis.framework.security.Login;
import org.molgenis.framework.security.SimpleLogin;
import org.molgenis.framework.ui.FormController;
import org.molgenis.framework.ui.ScreenController;
import org.molgenis.framework.ui.ScreenMessage;
import org.molgenis.framework.ui.SimpleScreenController;
import org.molgenis.framework.ui.SimpleScreenModel;
import org.molgenis.framework.ui.commands.AddBatchCommand;
import org.molgenis.framework.ui.commands.AddCommand;
import org.molgenis.framework.ui.commands.AddCsvFileCommand;
import org.molgenis.framework.ui.commands.ChangeListLimitCommand;
import org.molgenis.framework.ui.commands.CommandMenu;
import org.molgenis.framework.ui.commands.DownloadAllCommand;
import org.molgenis.framework.ui.commands.DownloadAllXlsCommand;
import org.molgenis.framework.ui.commands.DownloadSelectedCommand;
import org.molgenis.framework.ui.commands.DownloadSelectedXlsCommand;
import org.molgenis.framework.ui.commands.DownloadVisibleCommand;
import org.molgenis.framework.ui.commands.DownloadVisibleXlsCommand;
import org.molgenis.framework.ui.commands.EditSelectedCommand;
import org.molgenis.framework.ui.commands.GalaxyCommand;
import org.molgenis.framework.ui.commands.RemoveSelectedCommand;
import org.molgenis.framework.ui.commands.ScreenCommand;
import org.molgenis.framework.ui.commands.ViewEditViewCommand;
import org.molgenis.framework.ui.commands.ViewListViewCommand;
import org.molgenis.framework.ui.html.HtmlForm;
import org.molgenis.framework.ui.html.HtmlInput;
import org.molgenis.util.Entity;
import org.molgenis.util.SimpleTree;
import org.molgenis.util.tuple.Tuple;

public class FormModel<E extends Entity>
extends SimpleScreenModel {
    private int recordId;
    public static final String INPUT_SHOW = "__show";
    public static final String INPUT_COMMAND = "__command";
    public static final String INPUT_OFFSET = "__offset";
    public static final String INPUT_ID = "__id";
    public static final String INPUT_DOWNLOADFILENAME = "__filename";
    public static final String INPUT_BATCHADD = "__batchadd";
    public static final String INPUT_SELECTED = "massUpdate";
    public static final String ACTION_DOWNLOAD = "download";
    private static final Logger logger = Logger.getLogger(FormModel.class);
    private Map<String, ScreenCommand> commands = new LinkedHashMap<String, ScreenCommand>();
    private String header;
    private String description;
    private EntitiesImporter csvEntityImporter;
    private Class<E> entityClass;
    private int offset;
    private int limit;
    private int count;
    private String sortby = "";
    private QueryRule.Operator sortMode;
    Mode viewMode;
    private List<E> records = new ArrayList();
    private boolean readonly;
    private List<QueryRule> userRules;
    List<QueryRule> systemRules;
    private ScreenCommand currentCommand = null;
    private List<String> systemHiddenColumns = new Vector<String>();
    protected List<String> userHiddenColumns = new Vector<String>();
    private List<?> selectedIds;
    private List<ParentFilter> parentFilters = new ArrayList<ParentFilter>();
    private List<String> compactView = new ArrayList<String>();
    private static final long serialVersionUID = 8048540994925740038L;

    public void setRecordId(int recordId) {
        this.recordId = recordId;
    }

    public int getRecordId() {
        return this.recordId;
    }

    public List<HtmlInput<?>> getInputs() {
        return ((FormController)this.getController()).getInputs(this.create(), true).getInputs();
    }

    public List<HtmlInput<?>> getInputs(E entity) {
        return ((FormController)this.getController()).getInputs(entity, false).getInputs();
    }

    public FormModel(FormController<E> controller) {
        super(controller);
        this.setUserRules(new ArrayList<QueryRule>());
        this.setSystemRules(new ArrayList<QueryRule>());
        this.setLimit(5);
        this.setOffset(0);
        this.setCount(0);
        this.setSort(this.getIdField());
        this.setSortMode(QueryRule.Operator.SORTASC);
        this.setMode(Mode.LIST_VIEW);
        this.setMessages(new Vector<ScreenMessage>());
        this.setReadonly(false);
        super.addCommand(new DownloadVisibleCommand("download_txt_visible", this.getController()));
        super.addCommand(new DownloadSelectedCommand("download_txt_selected", this.getController()));
        super.addCommand(new DownloadAllCommand("download_txt_all", this.getController()));
        super.addCommand(new DownloadVisibleXlsCommand("download_xls_visible", this.getController()));
        super.addCommand(new DownloadSelectedXlsCommand("download_xls_selected", this.getController()));
        super.addCommand(new DownloadAllXlsCommand("download_xls_all", this.getController()));
        super.addCommand(new AddBatchCommand("upload_csv", this.getController()));
        super.addCommand(new AddCsvFileCommand("upload_csvfile", this.getController()));
        super.addCommand(new GalaxyCommand("send_all_to_galaxy", this.getController()));
        super.addCommand(new AddCommand("edit_new", this.getController()));
        super.addCommand(new EditSelectedCommand("edit_update_selected", this.getController()));
        super.addCommand(new RemoveSelectedCommand("edit_remove_selected", this.getController()));
        super.addCommand(new ViewEditViewCommand("editview", this.getController()));
        super.addCommand(new ViewListViewCommand("listview", this.getController()));
        ChangeListLimitCommand view_5 = new ChangeListLimitCommand("view_5show5", this.getController());
        view_5.setLimit(5);
        super.addCommand(view_5);
        ChangeListLimitCommand view_10 = new ChangeListLimitCommand("view_6show10", this.getController());
        view_5.setLimit(10);
        super.addCommand(view_10);
        ChangeListLimitCommand view_20 = new ChangeListLimitCommand("view_7show20", this.getController());
        view_20.setLimit(20);
        super.addCommand(view_20);
        ChangeListLimitCommand view_50 = new ChangeListLimitCommand("view_8show50", this.getController());
        view_50.setLimit(50);
        super.addCommand(view_50);
        ChangeListLimitCommand view_100 = new ChangeListLimitCommand("view_9show100", this.getController());
        view_100.setLimit(100);
        super.addCommand(view_100);
        ChangeListLimitCommand view_500 = new ChangeListLimitCommand("view_10show500", this.getController());
        view_500.setLimit(500);
        super.addCommand(view_500);
        for (ScreenCommand command : this.commands.values()) {
            super.addCommand(command);
        }
    }

    @Override
    public boolean isVisible() {
        Login login = ((SimpleScreenController)this.getController()).getApplicationController().getLogin();
        try {
            return login.canRead(this.getController());
        }
        catch (DatabaseException e) {
            e.printStackTrace();
            return false;
        }
    }

    public Vector<ScreenCommand> getToolbar() {
        Vector<ScreenCommand> toolbar = new Vector<ScreenCommand>();
        for (CommandMenu menu : this.getMenus()) {
            for (ScreenCommand c : menu.getCommands()) {
                if (!c.isToolbar() || !c.isVisible()) continue;
                toolbar.add(c);
            }
        }
        return toolbar;
    }

    public QueryRule[] getRules() {
        return this.getRules(true);
    }

    public QueryRule[] getRulesExclLimitOffset() {
        return this.getRules(false);
    }

    public QueryRule[] getRules(boolean includingLimitOffset) {
        ArrayList<QueryRule> rules = new ArrayList<QueryRule>();
        rules.addAll(this.getSystemRules());
        rules.addAll(this.getUserRules());
        if (includingLimitOffset) {
            if (this.limit > 0) {
                rules.add(new QueryRule(QueryRule.Operator.LIMIT, this.limit));
            }
            if (this.offset > 0) {
                rules.add(new QueryRule(QueryRule.Operator.OFFSET, this.offset));
            }
        }
        if (!StringUtils.equals((CharSequence)this.sortby, (CharSequence)"")) {
            rules.add(new QueryRule(this.sortMode, this.sortby));
        }
        logger.debug((Object)("rules.size: " + rules.size() + "=" + this.getSystemRules().size() + "+" + this.getUserRules().size()));
        return rules.toArray(new QueryRule[rules.size()]);
    }

    public E create() {
        try {
            Entity entity = (Entity)((FormController)this.getController()).getEntityClass().newInstance();
            for (ParentFilter pf : this.getParentFilters()) {
                FormModel parent = (FormModel)((ScreenController)((SimpleTree)((Object)this.getController())).get(pf.getParentForm())).getModel();
                List<E> records = parent.getRecords();
                if (records.size() <= 0) continue;
                Object value = ((Entity)records.get(0)).get(pf.getParentId());
                if (!(value instanceof List) && value != null) {
                    entity.set(pf.getXrefToParent(), value);
                }
                for (String labelName : pf.getParentLabels()) {
                    Object label = ((Entity)records.get(0)).get(labelName);
                    entity.set(pf.getXrefToParent() + "_" + labelName, label);
                }
            }
            return (E)entity;
        }
        catch (Exception e) {
            logger.error((Object)("failed to create class " + ((FormController)this.getController()).getEntityClass() + ": " + e));
            e.printStackTrace();
            return null;
        }
    }

    public Vector<String> getHeaders() {
        Vector<String> headers = new Vector<String>();
        for (HtmlInput<?> input : ((FormController)this.getController()).getInputs(this.create(), true).getInputs()) {
            headers.add(input.getLabel());
        }
        return headers;
    }

    public HtmlForm getNewRecordForm() throws DatabaseException {
        E entity = this.create();
        return ((FormController)this.getController()).getInputs(entity, true);
    }

    public Vector<HtmlForm> getRecordInputs() {
        Vector<HtmlForm> records = new Vector<HtmlForm>();
        try {
            for (Entity entity : this.getRecords()) {
                HtmlForm record = ((FormController)this.getController()).getInputs(entity, false);
                record.setReadonly(!this.getLogin().canWrite(entity));
                records.add(record);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return records;
    }

    public Vector<String> getFilters() throws DatabaseException {
        if (this.getUserRules() == null || this.getUserRules().isEmpty()) {
            return new Vector<String>();
        }
        Vector<String> filters = new Vector<String>();
        for (QueryRule rule : this.getUserRules()) {
            String label = "";
            if (rule.getField() != null) {
                label = this.getField(rule.getField());
            } else {
                QueryRule[] nestedRules = rule.getNestedRules();
                if (nestedRules != null && nestedRules.length > 0) {
                    label = "Any field";
                    rule = nestedRules[0];
                }
            }
            filters.add(label + " " + rule.getOperator().toString() + " " + rule.getValue());
        }
        return filters;
    }

    public void setLimit(int limit) {
        this.limit = limit;
    }

    public int getLimit() {
        if (this.viewMode.equals((Object)Mode.EDIT_VIEW)) {
            return 1;
        }
        return this.limit;
    }

    public void setCount(int count) {
        this.count = count;
    }

    public int getCount() {
        return this.count;
    }

    public String getSort() {
        return this.sortby;
    }

    public void setSort(String sort) {
        this.sortby = sort;
    }

    public QueryRule.Operator getSortMode() {
        return this.sortMode;
    }

    public void setSortMode(QueryRule.Operator sortMode) {
        this.sortMode = sortMode;
    }

    public void setOffset(int offset) {
        this.offset = offset;
    }

    public int getOffset() {
        return this.offset;
    }

    public void setMode(Mode viewmode) {
        this.viewMode = viewmode;
    }

    public Mode getMode() {
        return this.viewMode;
    }

    public void setRecords(List<E> recordlist) {
        this.records = recordlist;
    }

    public List<E> getRecords() {
        return this.records;
    }

    public String getHeader() {
        return this.header;
    }

    public void setHeader(String header) {
        this.header = header;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setUserRules(List<QueryRule> rules) {
        this.userRules = rules;
    }

    public List<QueryRule> getUserRules() {
        return this.userRules;
    }

    public List<QueryRule> getSystemRules() {
        ArrayList<QueryRule> rules = new ArrayList<QueryRule>();
        if (this.getParentFilters() != null && this.getParentFilters().size() > 0) {
            ArrayList<QueryRule> xref_filters = new ArrayList<QueryRule>();
            for (ParentFilter pf : this.getParentFilters()) {
                FormModel parent = (FormModel)((ScreenController)((SimpleTree)((Object)this.getController())).get(pf.getParentForm())).getModel();
                List<E> records = parent.getRecords();
                if (records.size() <= 0) continue;
                Object parentValue = ((Entity)records.get(0)).get(pf.getParentId());
                if (parentValue instanceof List) {
                    List values = (List)parentValue;
                    if (values.size() > 0) {
                        for (int i = 0; i < values.size(); ++i) {
                            QueryRule rule = new QueryRule(pf.getXrefToParent(), QueryRule.Operator.EQUALS, values.get(i));
                            if (xref_filters.size() > 0) {
                                xref_filters.add(new QueryRule(QueryRule.Operator.OR));
                            }
                            xref_filters.add(rule);
                        }
                        continue;
                    }
                    QueryRule rule = new QueryRule(pf.getXrefToParent(), QueryRule.Operator.EQUALS, Integer.MIN_VALUE);
                    if (xref_filters.size() > 0) {
                        xref_filters.add(new QueryRule(QueryRule.Operator.OR));
                    }
                    xref_filters.add(rule);
                    continue;
                }
                if (parentValue == null) continue;
                QueryRule rule = new QueryRule(pf.getXrefToParent(), QueryRule.Operator.EQUALS, parentValue);
                if (xref_filters.size() > 0) {
                    xref_filters.add(new QueryRule(QueryRule.Operator.OR));
                }
                xref_filters.add(rule);
            }
            if (rules.size() > 0) {
                rules.add(new QueryRule(QueryRule.Operator.OR));
            }
            rules.add(new QueryRule(xref_filters));
        }
        return rules;
    }

    public void setSystemRules(List<QueryRule> systemRules) {
        this.systemRules = systemRules;
    }

    public void setReadonly(boolean readonly) {
        this.readonly = readonly;
    }

    public boolean isReadonly() {
        if (this.getLogin() instanceof SimpleLogin) {
            return this.readonly;
        }
        try {
            return !this.getLogin().canWrite(this.create().getClass());
        }
        catch (DatabaseException e) {
            logger.warn((Object)e);
            return true;
        }
    }

    @Deprecated
    public File getDownloadFile(Database db, Tuple requestTuple) {
        String file = null;
        try {
            file = db.getFilesource() + requestTuple.getString(INPUT_DOWNLOADFILENAME);
            logger.error((Object)("file to download: " + file));
        }
        catch (Exception e) {
            logger.warn((Object)e);
            return null;
        }
        return new File(file);
    }

    public void resetUserHiddenColumns() {
        this.userHiddenColumns = new Vector<String>();
        this.userHiddenColumns.addAll(this.getSystemHiddenColumns());
    }

    public List<String> getSystemHiddenColumns() {
        return this.systemHiddenColumns;
    }

    public List<String> getUserHiddenColumns() {
        return this.userHiddenColumns;
    }

    public void setUserHiddenColumns(List<String> userHiddenColumns) {
        this.userHiddenColumns = userHiddenColumns;
    }

    public Login getLogin() {
        return ((SimpleScreenController)this.getController()).getApplicationController().getLogin();
    }

    public Class<E> getEntityClass() {
        return this.entityClass;
    }

    public void setEntityClass(Class<E> entityClass) {
        this.entityClass = entityClass;
    }

    public String getIdField() {
        E object = this.create();
        return object.getClass().getSimpleName() + "_" + object.getIdField();
    }

    public List<ScreenCommand> getCommands() {
        return new ArrayList<ScreenCommand>(this.commands.values());
    }

    public ScreenCommand getCurrentCommand() {
        return this.currentCommand;
    }

    public void setCurrentCommand(ScreenCommand currentCommand) {
        this.currentCommand = currentCommand;
    }

    public DatabasePager<E> getPager() {
        return ((FormController)this.getController()).getPager();
    }

    public List<?> getSelectedIds() {
        return this.selectedIds;
    }

    public void setSelectedIds(List<?> selected) {
        this.selectedIds = selected;
    }

    public void setParentFilters(List<ParentFilter> parentFilters) {
        this.parentFilters = parentFilters;
    }

    public List<ParentFilter> getParentFilters() {
        return this.parentFilters;
    }

    public E getCurrent() {
        if (this.getRecords() != null && this.getRecords().size() > 0) {
            return (E)((Entity)this.getRecords().get(0));
        }
        return null;
    }

    public FormController<E> getController() {
        return (FormController)super.getController();
    }

    public void setCompactView(List<String> compactView) {
        this.compactView = compactView;
    }

    public List<String> getCompactView() {
        return this.compactView;
    }

    public void setSystemHiddenColumns(Vector<String> systemHiddenColumns) {
        this.systemHiddenColumns = systemHiddenColumns;
    }

    public String getSearchField(String fieldName) {
        return ((FormController)this.getController()).getSearchField(fieldName);
    }

    public String getField(String searchFieldName) {
        return ((FormController)this.getController()).getField(searchFieldName);
    }

    public static enum Mode {
        LIST_VIEW("listview"),
        EDIT_VIEW("editview");

        public final String tag;

        private Mode(String tag) {
            this.tag = tag;
        }

        public String toString() {
            return this.tag;
        }
    }

    public static class ParentFilter {
        private String parentForm;
        private String parentId;
        private List<String> parentLabels;
        private String xrefToParent;

        public ParentFilter(String parentForm, String parentId, List<String> parentLabel, String xrefToParent) {
            this.parentForm = parentForm;
            this.parentId = parentId;
            this.parentLabels = parentLabel;
            this.xrefToParent = xrefToParent;
        }

        public String getParentForm() {
            return this.parentForm;
        }

        public String getParentId() {
            return this.parentId;
        }

        public String getXrefToParent() {
            return this.xrefToParent;
        }

        public void setParentForm(String parentForm) {
            this.parentForm = parentForm;
        }

        public void setParentId(String parentId) {
            this.parentId = parentId;
        }

        public void setXrefToParent(String xrefToParent) {
            this.xrefToParent = xrefToParent;
        }

        public List<String> getParentLabels() {
            return this.parentLabels;
        }

        public void setParentLabels(List<String> parentLabel) {
            this.parentLabels = parentLabel;
        }
    }
}

