/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.framework.ui;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.molgenis.MolgenisOptions;
import org.molgenis.framework.db.Database;
import org.molgenis.framework.security.Login;
import org.molgenis.framework.server.MolgenisContext;
import org.molgenis.framework.server.MolgenisRequest;
import org.molgenis.framework.ui.ApplicationModel;
import org.molgenis.framework.ui.FreemarkerView;
import org.molgenis.framework.ui.MenuController;
import org.molgenis.framework.ui.ScreenController;
import org.molgenis.framework.ui.ScreenMessage;
import org.molgenis.framework.ui.ScreenModel;
import org.molgenis.framework.ui.ScreenView;
import org.molgenis.framework.ui.SimpleScreenController;
import org.molgenis.framework.ui.html.FreemarkerInput;
import org.molgenis.framework.ui.html.HtmlSettings;
import org.molgenis.framework.ui.html.RichtextInput;
import org.molgenis.framework.ui.html.render.RenderDecorator;
import org.molgenis.util.FileLink;
import org.molgenis.util.HandleRequestDelegationException;

public class ApplicationController
extends SimpleScreenController<ApplicationModel> {
    public static final String MOLGENIS_TEMP_PATH = "molgenis_temp";
    private static final long serialVersionUID = 3108474555679524568L;
    private static final Logger logger = Logger.getLogger(ApplicationController.class);
    private Login login;
    private String galaxyUrl;
    private MolgenisOptions options;
    private transient MolgenisContext mc;
    public Map<String, Object> sessionVariables = new HashMap<String, Object>();

    public ApplicationController(MolgenisOptions options, Login login) {
        super("molgenis_userinterface_root", null, null);
        this.setModel(new ApplicationModel(this));
        this.setLogin(login);
        this.setOptions(options);
        try {
            HtmlSettings.defaultRenderDecorator = (RenderDecorator)Class.forName(options.render_decorator).newInstance();
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public ApplicationController(MolgenisContext mc) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        super("molgenis_userinterface_root", null, null);
        this.setModel(new ApplicationModel(this));
        this.setMolgenisContext(mc);
        HtmlSettings.defaultRenderDecorator = (RenderDecorator)Class.forName(mc.getUsedOptions().render_decorator).newInstance();
    }

    public Login getLogin() {
        return this.login;
    }

    public void setLogin(Login login) {
        this.login = login;
    }

    @Override
    public FileLink getTempFile() throws IOException {
        File temp = File.createTempFile(MOLGENIS_TEMP_PATH, "");
        logger.debug((Object)("create temp file: " + temp));
        return new FileLink(temp, "download/" + temp.getName());
    }

    public void handleRequest(Database db, MolgenisRequest request) throws Exception, HandleRequestDelegationException {
        this.handleRequest(db, request, null);
    }

    @Override
    public void reload(Database db) {
        for (ScreenController s : this.getChildren()) {
            try {
                s.reload(db);
            }
            catch (Exception e) {
                logger.warn((Object)e);
                s.getModel().getMessages().add(new ScreenMessage("reload failed: " + e.getMessage(), false));
            }
        }
    }

    @Override
    public ScreenModel.Show handleRequest(Database db, MolgenisRequest request, OutputStream out) throws HandleRequestDelegationException, Exception {
        ScreenController target;
        logger.info((Object)("delegating handleRequest(" + request.toString() + ")"));
        String screen = request.getString("__target");
        if (screen != null && screen.equals(this.getName())) {
            if (request.getString("select") != null) {
                ScreenController selected = (ScreenController)this.get(request.getString("select"));
                ScreenController currentChild = selected;
                for (ScreenController currentParent = (ScreenController)selected.getParent(); currentParent != null; currentParent = (ScreenController)currentParent.getParent()) {
                    if (currentParent instanceof MenuController) {
                        ((MenuController)currentParent).setSelected(currentChild.getName());
                    }
                    currentChild = currentParent;
                }
            }
            return ScreenModel.Show.SHOW_MAIN;
        }
        if (!request.isNull("GALAXY_URL")) {
            this.setGalaxyUrl(request.getString("GALAXY_URL"));
            logger.info((Object)("User was forwarded to Molgenis running @ " + request.getAppLocation()));
            logger.info((Object)("User was forwarded to Molgenis by Galaxy running @ " + this.getGalaxyUrl()));
        }
        if ((target = (ScreenController)this.get(screen)) != null) {
            if (!target.equals(this)) {
                return target.handleRequest(db, request, null);
            }
        } else {
            logger.debug((Object)("handleRequest(" + request + "): no request needs to be handled"));
        }
        return ScreenModel.Show.SHOW_MAIN;
    }

    public void clearAllMessages() {
        for (ScreenController s : this.getAllChildren()) {
            s.getModel().getMessages().clear();
        }
    }

    @Override
    public Database getDatabase() {
        throw new UnsupportedOperationException("getDatabase must be implemented for use");
    }

    public String getGalaxyUrl() {
        return this.galaxyUrl;
    }

    public void setGalaxyUrl(String galaxyUrl) {
        this.galaxyUrl = galaxyUrl;
    }

    @Override
    @Deprecated
    public String getCustomHtmlHeaders() {
        return new FreemarkerInput("dummy").getCustomHtmlHeaders() + new RichtextInput("dummy").getCustomHtmlHeaders() + super.getCustomHtmlHeaders();
    }

    @Deprecated
    public MolgenisOptions getOptions() {
        return this.options;
    }

    @Deprecated
    public void setOptions(MolgenisOptions options) {
        this.options = options;
    }

    public MolgenisContext getMolgenisContext() {
        return this.mc;
    }

    public void setMolgenisContext(MolgenisContext mc) {
        this.mc = mc;
    }

    @Override
    public ScreenView getView() {
        return new FreemarkerView("ApplicationView.ftl", (ScreenModel)this.getModel());
    }
}

