/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.framework.tupletable.impl;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import org.molgenis.framework.tupletable.TupleTable;
import org.molgenis.framework.tupletable.impl.MemoryTable;
import org.molgenis.util.tuple.Tuple;
import org.molgenis.util.tuple.ValueIndexTuple;

public class MemoryTableFactory {
    public static TupleTable create() {
        return MemoryTableFactory.create(5, 5);
    }

    public static TupleTable create(int nrows, int ncols) {
        LinkedHashMap<String, Integer> headerIndex = new LinkedHashMap<String, Integer>(ncols);
        for (int j = 1; j <= ncols; ++j) {
            headerIndex.put("col" + j, j - 1);
        }
        ArrayList<Tuple> tuples = new ArrayList<Tuple>(nrows);
        for (int i = 1; i <= nrows; ++i) {
            ArrayList<String> values = new ArrayList<String>(ncols);
            for (int j = 1; j <= ncols; ++j) {
                values.add("val" + j + "," + i);
            }
            tuples.add(new ValueIndexTuple(headerIndex, values));
        }
        return new MemoryTable(tuples);
    }
}

