/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.framework.tupletable.impl;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.molgenis.framework.db.QueryRule;
import org.molgenis.framework.tupletable.FilterableTupleTable;
import org.molgenis.framework.tupletable.TableException;
import org.molgenis.model.elements.Field;
import org.molgenis.util.tuple.KeyValueTuple;
import org.molgenis.util.tuple.Tuple;

public class EditableTableDecorator
implements FilterableTupleTable {
    FilterableTupleTable decoratedTable;

    public EditableTableDecorator(FilterableTupleTable decoratedTable) {
        this.decoratedTable = decoratedTable;
    }

    @Override
    public List<Field> getColumns() throws TableException {
        return this.decoratedTable.getColumns();
    }

    @Override
    public List<Field> getAllColumns() throws TableException {
        return this.decoratedTable.getAllColumns();
    }

    @Override
    public List<Tuple> getRows() throws TableException {
        try {
            ArrayList<Tuple> editableRows = new ArrayList<Tuple>();
            for (Tuple t : this.decoratedTable.getRows()) {
                KeyValueTuple tuple = new KeyValueTuple();
                for (String colName : t.getColNames()) {
                    tuple.set(colName, "<input style=\"width:100%; padding:0px \" type=\"text\" value=\"" + t.get(colName) + "\">");
                }
                editableRows.add(tuple);
            }
            return editableRows;
        }
        catch (Exception e) {
            throw new TableException(e);
        }
    }

    @Override
    public Iterator<Tuple> iterator() {
        return this.decoratedTable.iterator();
    }

    @Override
    public void close() throws TableException {
        this.decoratedTable.close();
    }

    @Override
    public int getCount() throws TableException {
        return this.decoratedTable.getCount();
    }

    @Override
    public int getColCount() throws TableException {
        return this.decoratedTable.getColCount();
    }

    @Override
    public int getLimit() {
        return this.decoratedTable.getLimit();
    }

    @Override
    public int getColLimit() {
        return this.decoratedTable.getColLimit();
    }

    @Override
    public void setLimit(int limit) {
        this.decoratedTable.setLimit(limit);
    }

    @Override
    public void setColLimit(int limit) {
        this.decoratedTable.setColLimit(limit);
    }

    @Override
    public int getOffset() {
        return this.decoratedTable.getOffset();
    }

    @Override
    public int getColOffset() {
        return this.decoratedTable.getColOffset();
    }

    @Override
    public void setOffset(int offset) {
        this.decoratedTable.setOffset(offset);
    }

    @Override
    public void setColOffset(int offset) {
        this.decoratedTable.setColOffset(offset);
    }

    @Override
    public void reset() {
        this.decoratedTable.reset();
    }

    @Override
    public void setLimitOffset(int limit, int offset) {
        this.decoratedTable.setLimitOffset(limit, offset);
    }

    @Override
    public void setFilters(List<QueryRule> rules) throws TableException {
        this.decoratedTable.setFilters(rules);
    }

    @Override
    public List<QueryRule> getFilters() {
        return this.decoratedTable.getFilters();
    }

    @Override
    public QueryRule getSortRule() {
        return this.decoratedTable.getSortRule();
    }

    @Override
    public void hideColumn(String columnName) {
        this.decoratedTable.hideColumn(columnName);
    }

    @Override
    public void showColumn(String columnName) {
        this.decoratedTable.showColumn(columnName);
    }

    @Override
    public List<Field> getHiddenColumns() {
        return this.decoratedTable.getHiddenColumns();
    }

    @Override
    public void setFirstColumnFixed(boolean firstColumnFixed) {
        this.decoratedTable.setFirstColumnFixed(firstColumnFixed);
    }

    @Override
    public boolean isFirstColumnFixed() {
        return this.decoratedTable.isFirstColumnFixed();
    }
}

