/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.framework.tupletable.impl;

import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.zip.DataFormatException;
import org.apache.commons.io.IOUtils;
import org.molgenis.framework.tupletable.AbstractTupleTable;
import org.molgenis.framework.tupletable.TableException;
import org.molgenis.io.csv.CsvReader;
import org.molgenis.model.elements.Field;
import org.molgenis.util.tuple.KeyValueTuple;
import org.molgenis.util.tuple.Tuple;

public class CsvTable
extends AbstractTupleTable {
    private CsvReader csvReader;
    private InputStream countStream;
    private List<Field> columns = new ArrayList<Field>();
    File csvFile;
    String csvString;
    int rowCount = -1;

    public CsvTable(File csvFile) throws Exception {
        if (csvFile == null) {
            throw new NullPointerException("Creation of CsvTable failed: csvFile == null");
        }
        if (!csvFile.exists()) {
            throw new IllegalArgumentException("Creation of CsvTable failed: csvFile does not exist");
        }
        this.csvFile = csvFile;
        this.resetStreams();
        this.loadColumns();
    }

    public CsvTable(String csvString) throws TableException {
        if (csvString == null) {
            throw new NullPointerException("Creation of CsvTable failed: csvString == null");
        }
        this.csvString = csvString;
        try {
            this.resetStreams();
            this.loadColumns();
        }
        catch (Exception e) {
            throw new TableException(e);
        }
    }

    @Override
    public int getCount() throws TableException {
        if (this.rowCount == -1) {
            LineNumberReader lineReader = new LineNumberReader(new InputStreamReader(this.countStream, Charset.forName("UTF-8")));
            try {
                String line = null;
                while ((line = lineReader.readLine()) != null) {
                    line = line.trim();
                }
                this.rowCount = lineReader.getLineNumber() - 1;
            }
            catch (Exception e) {
                throw new TableException(e);
            }
            finally {
                IOUtils.closeQuietly((Reader)lineReader);
            }
        }
        return this.rowCount;
    }

    private void loadColumns() throws Exception {
        Iterator<String> it = this.csvReader.colNamesIterator();
        while (it.hasNext()) {
            Field f = new Field(it.next());
            this.columns.add(f);
        }
    }

    @Override
    public List<Field> getAllColumns() {
        return this.columns;
    }

    @Override
    public List<Tuple> getRows() {
        ArrayList<Tuple> result = new ArrayList<Tuple>();
        for (Tuple row : this) {
            result.add(row);
        }
        return result;
    }

    @Override
    public Iterator<Tuple> iterator() {
        try {
            this.resetStreams();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (this.getLimit() > 0 || this.getOffset() > 0 || this.getColOffset() > 0 || this.getColLimit() > 0) {
            return new TupleIterator(this.csvReader.iterator(), this.getLimit(), this.getOffset(), this.getColLimit(), this.getColOffset());
        }
        return this.csvReader.iterator();
    }

    @Override
    public void close() throws TableException {
        IOUtils.closeQuietly((Closeable)this.csvReader);
        IOUtils.closeQuietly((InputStream)this.countStream);
    }

    private void resetStreams() throws FileNotFoundException, IOException, DataFormatException {
        IOUtils.closeQuietly((Closeable)this.csvReader);
        if (this.csvFile != null) {
            this.csvReader = new CsvReader(this.csvFile);
            this.countStream = new FileInputStream(this.csvFile);
        } else {
            this.csvReader = new CsvReader(new StringReader(this.csvString));
            this.countStream = new ByteArrayInputStream(this.csvString.getBytes(Charset.forName("UTF-8")));
        }
    }

    private static class TupleIterator
    implements Iterator<Tuple> {
        Iterator<Tuple> it;
        Tuple next;
        int limit = 0;
        int offset = 0;
        int index = 0;
        int count = 0;
        int colLimit = 0;
        int colOffset = 0;

        public TupleIterator(Iterator<Tuple> it, int limit, int offset, int colLimit, int colOffset) {
            this.it = it;
            this.limit = limit;
            this.offset = offset;
            this.colLimit = colLimit;
            this.colOffset = colOffset;
        }

        @Override
        public boolean hasNext() {
            while (this.index++ < this.offset) {
                this.it.next();
            }
            if (this.limit != 0 && this.count++ >= this.limit) {
                return false;
            }
            if (this.colLimit > 0 || this.colOffset > 0) {
                this.next = this.it.next();
                if (this.next != null) {
                    KeyValueTuple tuple = new KeyValueTuple();
                    int colIndex = 1;
                    int colCount = 0;
                    for (String f : this.next.getColNames()) {
                        if (this.colOffset == 0 || colIndex > this.colOffset) {
                            tuple.set(f, this.next.get(f));
                            if (this.colLimit != 0 && ++colCount > this.colLimit) break;
                        }
                        ++colIndex;
                    }
                    this.next = tuple;
                }
            } else {
                this.next = this.it.next();
            }
            return this.next != null;
        }

        @Override
        public Tuple next() {
            if (this.next != null || this.hasNext()) {
                return this.next;
            }
            return null;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

