/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.framework.server.services;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.Type;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.molgenis.framework.db.Database;
import org.molgenis.framework.db.DatabaseException;
import org.molgenis.framework.db.Query;
import org.molgenis.framework.db.QueryRule;
import org.molgenis.framework.server.MolgenisContext;
import org.molgenis.framework.server.MolgenisRequest;
import org.molgenis.framework.server.MolgenisResponse;
import org.molgenis.framework.server.MolgenisService;
import org.molgenis.util.Entity;

public class MolgenisXrefService
implements MolgenisService {
    static final String JSON_KEY_VALUE = "{\"value\":\"%s\", \"text\":\"%s\"}";

    public MolgenisXrefService(MolgenisContext mc) {
    }

    @Override
    public void handleRequest(MolgenisRequest req, MolgenisResponse res) throws ParseException, DatabaseException, IOException {
        MolgenisXrefService.handleXrefRequest(req.getDatabase(), req, res);
    }

    public static void handleXrefRequest(Database db, MolgenisRequest req, MolgenisResponse res) throws DatabaseException {
        Logger logger = Logger.getLogger(MolgenisXrefService.class);
        try {
            logger.debug((Object)("handling XREF request " + req));
            String searchTerm = req.getString("searchTerm");
            String xrefField = req.getString("xrefField");
            Class<? extends Entity> xrefEntity = MolgenisXrefService.getClassForName(req.getString("xrefEntity"));
            String xrefLabel = req.getString("xrefLabels");
            boolean nillable = req.getBoolean("nillable");
            if (searchTerm == null || xrefField == null || xrefEntity == null || xrefLabel == null) {
                throw new IllegalArgumentException(String.format("parameters are invalid in req: %s", req));
            }
            String xref_filters = req.getString("filters");
            Collection filters = null;
            boolean hasFilters = StringUtils.isNotEmpty((CharSequence)xref_filters);
            if (hasFilters) {
                Type collectionType = new TypeToken<Collection<QueryRule>>(){}.getType();
                Gson gson = new Gson();
                filters = (Collection)gson.fromJson(xref_filters, collectionType);
            }
            ArrayList<String> xref_labels = new ArrayList<String>();
            for (String label : xrefLabel.split(",")) {
                xref_labels.add(label.toString());
            }
            HttpServletResponse response = res.getResponse();
            response.setHeader("Cache-Control", "max-age=0");
            response.setContentType("application/json");
            List<? extends Entity> records = MolgenisXrefService.getRecords(db, searchTerm, xrefEntity, filters, xref_labels);
            String json = MolgenisXrefService.toJson(xrefField, xref_labels, records, nillable);
            logger.debug((Object)json);
            PrintWriter out = response.getWriter();
            out.print(json);
            out.close();
        }
        catch (ClassNotFoundException e) {
            logger.warn((Object)e);
        }
        catch (IOException e) {
            logger.warn((Object)e);
        }
    }

    private static String toJson(String xrefField, List<String> xref_labels, List<? extends Entity> records, boolean nillable) {
        LinkedHashMap<String, String> values = new LinkedHashMap<String, String>();
        if (nillable) {
            values.put("", "&nbsp;");
        }
        for (int i = 0; i < records.size(); ++i) {
            String key = records.get(i).get(xrefField).toString();
            StringBuilder valueBuilder = new StringBuilder();
            for (int j = 0; j < xref_labels.size(); ++j) {
                if (j > 0) {
                    valueBuilder.append('|');
                }
                valueBuilder.append(records.get(i).get(xref_labels.get(j)).toString());
            }
            values.put(key, valueBuilder.toString());
        }
        ArrayList<String> keyValuePairs = new ArrayList<String>();
        for (Map.Entry entry : values.entrySet()) {
            keyValuePairs.add(String.format(JSON_KEY_VALUE, StringEscapeUtils.escapeEcmaScript((String)((String)entry.getKey())), StringEscapeUtils.escapeEcmaScript((String)((String)entry.getValue())).replaceAll("\\\\'", "\\'")));
        }
        String json = String.format("[%s]", StringUtils.join(keyValuePairs, (String)","));
        return json;
    }

    public static List<? extends Entity> getRecords(Database db, String searchTerm, Class<? extends Entity> xrefEntity, Collection<QueryRule> filters, List<String> searchFields) throws DatabaseException {
        List<Object> result = Collections.emptyList();
        try {
            Query<? extends Entity> q = db.query(xrefEntity);
            if (filters != null && !filters.isEmpty()) {
                q.addRules(filters.toArray(new QueryRule[filters.size()]));
            }
            for (String xref_label : searchFields) {
                if (StringUtils.isNotEmpty((CharSequence)searchTerm)) {
                    q.like(xref_label, "%" + searchTerm + "%");
                    q.or();
                }
                q.sortASC(xref_label);
            }
            q.limit(100);
            result = q.find();
            return result;
        }
        catch (Exception ex) {
            throw new DatabaseException(ex);
        }
        finally {
            return result;
        }
    }

    private static Class<? extends Entity> getClassForName(String entityName) throws ClassNotFoundException {
        return Class.forName(entityName);
    }
}

