/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.framework.server.services;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.util.Hashtable;
import javax.servlet.ServletOutputStream;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;
import org.molgenis.framework.server.MolgenisContext;
import org.molgenis.framework.server.MolgenisRequest;
import org.molgenis.framework.server.MolgenisResponse;
import org.molgenis.framework.server.MolgenisService;
import org.molgenis.framework.server.services.MolgenisRapiService;

public class MolgenisTmpFileService
implements MolgenisService {
    Logger logger = Logger.getLogger(MolgenisRapiService.class);
    Hashtable<String, Object> restParams;
    private MolgenisContext mc;

    public MolgenisTmpFileService(MolgenisContext mc) {
        this.mc = mc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleRequest(MolgenisRequest request, MolgenisResponse response) throws IOException {
        String url = request.getRequest().getRequestURI();
        String variant = url.substring(url.indexOf("/") + 1, url.indexOf("/tmpfile"));
        BufferedInputStream in = null;
        ServletOutputStream out = request.getResponse().getOutputStream();
        try {
            int nBytes;
            String urlBase = variant + "/tmpfile/";
            String urlFile = url.substring(urlBase.length() + 1);
            File tmpDir = new File(System.getProperty("java.io.tmpdir"));
            File filePath = new File(tmpDir.getAbsolutePath() + File.separatorChar + urlFile);
            URL localURL = filePath.toURI().toURL();
            URLConnection conn = localURL.openConnection();
            in = new BufferedInputStream(conn.getInputStream());
            String mimetype = this.mc.getServletContext().getMimeType(filePath.getName());
            if (mimetype != null) {
                request.getResponse().setContentType(mimetype);
            }
            request.getResponse().setContentLength((int)filePath.length());
            byte[] buffer = new byte[2048];
            while ((nBytes = ((InputStream)in).read(buffer)) > 0) {
                out.write(buffer, 0, nBytes);
            }
            out.flush();
            this.logger.info((Object)("serving " + request.getRequest().getRequestURI()));
        }
        catch (Exception e) {
            try {
                byte[] header = ("Temporary file " + variant + " location error:\n").getBytes(Charset.forName("UTF-8"));
                out.write(header, 0, header.length);
                byte[] exception = ("loading of failed: " + e).getBytes(Charset.forName("UTF-8"));
                out.write(exception, 0, exception.length);
                this.logger.error((Object)("loading of failed: " + e));
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly((OutputStream)out);
                IOUtils.closeQuietly(in);
                throw throwable;
            }
            IOUtils.closeQuietly((OutputStream)out);
            IOUtils.closeQuietly((InputStream)in);
        }
        IOUtils.closeQuietly((OutputStream)out);
        IOUtils.closeQuietly((InputStream)in);
    }
}

