/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.framework.server;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.molgenis.framework.db.QueryRule;

public class QueryRuleUtil {
    public static String toRESTstring(QueryRule ... rules) {
        return QueryRuleUtil.toRESTstring(Arrays.asList(rules));
    }

    public static String toRESTstring(List<QueryRule> rules) {
        StringBuffer filters = new StringBuffer();
        QueryRule previousRule = null;
        for (QueryRule r : rules) {
            if (rules.indexOf(r) > 0) {
                if (QueryRule.Operator.OR.equals((Object)previousRule.getOperator())) {
                    filters.append("\\|");
                } else {
                    filters.append("\\&");
                }
            }
            if (r.getField() != null) {
                filters.append(r.getField());
            }
            filters.append((Object)r.getOperator());
            if (r.getValue() instanceof String) {
                filters.append("'" + r.getValue() + "'");
            } else {
                filters.append(r.getValue());
            }
            previousRule = r;
        }
        return filters.toString().replace("=", "\\=");
    }

    public static List<QueryRule> fromRESTstring(String RESTstring) {
        String[] ruleStrings;
        ArrayList<QueryRule> rules = new ArrayList<QueryRule>();
        if (RESTstring == null || RESTstring.equals("")) {
            return null;
        }
        for (String rule : ruleStrings = RESTstring.replace("\\=", "=").split("&")) {
            String field = null;
            QueryRule.Operator operator = null;
            String value = null;
            int operatorLength = 0;
            for (QueryRule.Operator o : QueryRule.Operator.values()) {
                int index = rule.indexOf(o.toString());
                if (index <= -1 || o.toString().length() <= operatorLength) continue;
                operatorLength = o.toString().length();
                field = rule.substring(0, index);
                operator = o;
                value = rule.substring(index + operatorLength, rule.length());
                if (value.charAt(0) != '\'' || value.charAt(value.length() - 1) != '\'') continue;
                value = value.substring(1, value.length() - 1);
            }
            if (field == null || field.equals("")) {
                rules.add(new QueryRule(operator, value));
                continue;
            }
            rules.add(new QueryRule(field, operator, value));
        }
        return rules;
    }
}

