/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.framework.server;

import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import org.molgenis.MolgenisOptions;
import org.molgenis.framework.server.TokenFactory;
import org.molgenis.services.SchedulingService;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.impl.StdSchedulerFactory;

public class MolgenisContext {
    private ServletConfig sc;
    private MolgenisOptions usedOptions;
    private String variant;
    private TokenFactory tokenFactory;
    private SchedulingService schedulingService;

    public MolgenisContext(ServletConfig sc, MolgenisOptions usedOptions, String variant) {
        this.sc = sc;
        this.usedOptions = usedOptions;
        this.variant = variant;
        this.tokenFactory = new TokenFactory();
        this.schedulingService = new SchedulingService();
    }

    public SchedulingService getSchedulingService() {
        return this.schedulingService;
    }

    public Scheduler getScheduler() throws SchedulerException {
        StdSchedulerFactory ssf = (StdSchedulerFactory)this.sc.getServletContext().getAttribute("org.quartz.impl.StdSchedulerFactory.KEY");
        if (ssf != null) {
            return ssf.getScheduler();
        }
        throw new SchedulerException("Scheduler not started");
    }

    public TokenFactory getTokenFactory() {
        return this.tokenFactory;
    }

    public String getVariant() {
        return this.variant;
    }

    public ServletConfig getServletConfig() {
        return this.sc;
    }

    public ServletContext getServletContext() {
        return this.sc.getServletContext();
    }

    public MolgenisOptions getUsedOptions() {
        return this.usedOptions;
    }

    public void setUsedOptions(MolgenisOptions usedOptions) {
        this.usedOptions = usedOptions;
    }
}

