/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.framework.db;

import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.text.ParseException;
import java.util.List;
import org.apache.log4j.Logger;
import org.molgenis.framework.db.Database;
import org.molgenis.framework.db.DatabaseException;
import org.molgenis.framework.db.Mapper;
import org.molgenis.framework.db.QueryRule;
import org.molgenis.io.TupleReader;
import org.molgenis.io.TupleWriter;
import org.molgenis.util.Entity;
import org.molgenis.util.tuple.EntityTuple;
import org.molgenis.util.tuple.Tuple;

public abstract class AbstractMapper<E extends Entity>
implements Mapper<E> {
    private final Database database;
    public static final int BATCH_SIZE = 500;
    private static final Logger logger = Logger.getLogger(AbstractMapper.class);

    public AbstractMapper(Database database) {
        this.database = database;
    }

    @Override
    public Database getDatabase() {
        return this.database;
    }

    @Override
    public abstract E create();

    @Override
    public abstract List<E> createList(int var1);

    protected abstract void prepareFileAttachements(List<E> var1, File var2) throws IOException;

    protected abstract boolean saveFileAttachements(List<E> var1, File var2) throws IOException;

    @Override
    public abstract int executeAdd(List<? extends E> var1) throws DatabaseException;

    @Override
    public abstract int executeUpdate(List<? extends E> var1) throws DatabaseException;

    @Override
    public abstract int executeRemove(List<? extends E> var1) throws DatabaseException;

    @Override
    public abstract void resolveForeignKeys(List<E> var1) throws DatabaseException, ParseException;

    public abstract void storeMrefs(List<E> var1) throws DatabaseException, IOException, ParseException;

    public abstract void removeMrefs(List<E> var1) throws SQLException, IOException, DatabaseException, ParseException;

    @Override
    public void find(TupleWriter writer, QueryRule ... rules) throws DatabaseException {
        this.find(writer, (List<String>)null, rules);
    }

    public int add(E entity) throws DatabaseException {
        List<E> entities = this.createList(1);
        entities.add(entity);
        return this.add(entities);
    }

    @Override
    public int add(List<E> entities) throws DatabaseException {
        int updatedRows = 0;
        boolean privateTx = !this.getDatabase().inTx();
        try {
            if (privateTx) {
                this.getDatabase().beginTx();
            }
            this.prepareFileAttachements(entities, this.getDatabase().getFilesource());
            for (int i = 0; i < entities.size(); i += 500) {
                this.resolveForeignKeys(entities);
                int endindex = Math.min(i + 500, entities.size());
                List<E> sublist = entities.subList(i, endindex);
                updatedRows += this.executeAdd(sublist);
            }
            this.storeMrefs(entities);
            if (this.saveFileAttachements(entities, this.getDatabase().getFilesource())) {
                this.update(entities);
            }
            if (privateTx) {
                this.getDatabase().commitTx();
            }
            logger.debug((Object)(updatedRows + " " + this.create().getClass().getSimpleName() + " objects added"));
            return updatedRows;
        }
        catch (Exception sqle) {
            sqle.printStackTrace();
            if (privateTx) {
                this.getDatabase().rollbackTx();
            }
            logger.error((Object)("ADD failed on " + this.create().getClass().getSimpleName() + ": " + sqle.getMessage()));
            throw new DatabaseException(sqle);
        }
    }

    @Override
    public int add(TupleReader reader, TupleWriter writer) throws DatabaseException {
        int rowsAffected = 0;
        boolean privateTx = !this.getDatabase().inTx();
        try {
            if (privateTx) {
                this.getDatabase().beginTx();
            }
            List<E> entities = this.toList(reader, 500);
            if (writer != null) {
                writer.writeColNames(new EntityTuple((Entity)entities.get(0)).getColNames());
            }
            while (entities.size() > 0) {
                this.resolveForeignKeys(entities);
                rowsAffected += this.getDatabase().add(entities);
                if (writer != null) {
                    for (Entity entity : entities) {
                        writer.write(new EntityTuple(entity));
                    }
                }
                entities = this.toList(reader, 500);
            }
            if (privateTx) {
                this.getDatabase().commitTx();
            }
        }
        catch (Exception e) {
            if (privateTx) {
                this.getDatabase().rollbackTx();
            }
            throw new DatabaseException("add(" + this.create().getClass().getSimpleName() + ") failed: " + e.getMessage(), e);
        }
        return rowsAffected;
    }

    public int update(E entity) throws DatabaseException {
        List<E> entities = this.createList(1);
        entities.add(entity);
        return this.update(entities);
    }

    @Override
    public int update(List<E> entities) throws DatabaseException {
        int updatedRows = 0;
        boolean privateTx = !this.getDatabase().inTx();
        try {
            if (privateTx) {
                this.getDatabase().beginTx();
            }
            this.prepareFileAttachements(entities, this.getDatabase().getFilesource());
            for (int i = 0; i < entities.size(); i += 500) {
                int endindex = Math.min(i + 500, entities.size());
                List<E> sublist = entities.subList(i, endindex);
                this.saveFileAttachements(sublist, this.getDatabase().getFilesource());
                this.resolveForeignKeys(sublist);
                updatedRows += this.executeUpdate(sublist);
            }
            this.storeMrefs(entities);
            if (privateTx) {
                this.getDatabase().commitTx();
            }
            logger.info((Object)(updatedRows + " " + this.create().getClass().getSimpleName() + " objects updated"));
            return updatedRows;
        }
        catch (Exception sqle) {
            if (privateTx) {
                this.getDatabase().rollbackTx();
            }
            throw new DatabaseException("Update(" + this.create().getClass().getSimpleName() + ") failed: " + sqle.getMessage(), sqle);
        }
    }

    @Override
    public int update(TupleReader reader) throws DatabaseException {
        int rowsAffected = 0;
        boolean privateTx = !this.getDatabase().inTx();
        try {
            if (privateTx) {
                this.getDatabase().beginTx();
            }
            List<E> entities = this.toList(reader, 500);
            while (entities.size() > 0) {
                this.resolveForeignKeys(entities);
                rowsAffected += this.getDatabase().update(entities);
                entities = this.toList(reader, 500);
            }
            if (privateTx) {
                this.getDatabase().commitTx();
            }
        }
        catch (Exception e) {
            if (privateTx) {
                this.getDatabase().rollbackTx();
            }
            throw new DatabaseException("update(" + this.create().getClass().getSimpleName() + ") failed: " + e.getMessage(), e);
        }
        return rowsAffected;
    }

    public int remove(E entity) throws DatabaseException {
        List<E> entities = this.createList(1);
        entities.add(entity);
        return this.remove(entities);
    }

    @Override
    public int remove(List<E> entities) throws DatabaseException {
        int updatedRows = 0;
        boolean privateTx = !this.getDatabase().inTx();
        try {
            if (privateTx) {
                this.getDatabase().beginTx();
            }
            this.prepareFileAttachements(entities, this.getDatabase().getFilesource());
            for (int i = 0; i < entities.size(); i += 500) {
                int endindex = Math.min(i + 500, entities.size());
                List<E> sublist = entities.subList(i, endindex);
                this.resolveForeignKeys(sublist);
                this.removeMrefs(sublist);
                updatedRows += this.executeRemove(sublist);
                this.getDatabase().flush();
            }
            this.getDatabase().flush();
            if (privateTx) {
                this.getDatabase().commitTx();
            }
            logger.info((Object)(updatedRows + " " + this.create().getClass().getSimpleName() + " objects removed"));
            return updatedRows;
        }
        catch (Exception sqle) {
            if (privateTx) {
                this.getDatabase().rollbackTx();
            }
            logger.error((Object)("remove failed on " + this.create().getClass().getSimpleName() + ": " + sqle.getMessage()));
            sqle.printStackTrace();
            throw new DatabaseException("remove(" + this.create().getClass().getSimpleName() + ") failed: " + sqle.getMessage(), sqle);
        }
    }

    @Override
    public int remove(TupleReader reader) throws DatabaseException {
        int rowsAffected = 0;
        boolean privateTx = !this.getDatabase().inTx();
        try {
            if (privateTx) {
                this.getDatabase().beginTx();
            }
            List<E> entities = this.toList(reader, 500);
            while (entities.size() > 0) {
                this.resolveForeignKeys(entities);
                rowsAffected += this.getDatabase().remove(entities);
                entities = this.toList(reader, 500);
            }
            if (privateTx) {
                this.getDatabase().commitTx();
            }
        }
        catch (Exception e) {
            if (privateTx) {
                this.getDatabase().rollbackTx();
            }
            throw new DatabaseException("remove(" + this.create().getClass().getSimpleName() + ") failed: " + e.getMessage(), e);
        }
        return rowsAffected;
    }

    @Override
    public List<E> toList(TupleReader reader, int limit) throws DatabaseException {
        List<E> entities = this.createList(10);
        try {
            for (Tuple row : reader) {
                E e = this.create();
                e.set(row, false);
                entities.add(e);
            }
        }
        catch (Exception ex) {
            throw new DatabaseException(ex);
        }
        return entities;
    }
}

