/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis;

import java.util.Map;
import java.util.TreeMap;
import org.apache.log4j.Logger;
import org.molgenis.fieldtypes.BoolField;
import org.molgenis.fieldtypes.CategoricalField;
import org.molgenis.fieldtypes.DateField;
import org.molgenis.fieldtypes.DatetimeField;
import org.molgenis.fieldtypes.DecimalField;
import org.molgenis.fieldtypes.EmailField;
import org.molgenis.fieldtypes.EnumField;
import org.molgenis.fieldtypes.FieldType;
import org.molgenis.fieldtypes.FileField;
import org.molgenis.fieldtypes.HtmlField;
import org.molgenis.fieldtypes.HyperlinkField;
import org.molgenis.fieldtypes.ImageField;
import org.molgenis.fieldtypes.IntField;
import org.molgenis.fieldtypes.LongField;
import org.molgenis.fieldtypes.MrefField;
import org.molgenis.fieldtypes.StringField;
import org.molgenis.fieldtypes.TextField;
import org.molgenis.fieldtypes.XrefField;
import org.molgenis.framework.ui.html.HtmlInput;
import org.molgenis.framework.ui.html.HtmlInputException;
import org.molgenis.model.MolgenisModelException;
import org.molgenis.model.elements.Field;

public class MolgenisFieldTypes {
    private static Map<String, FieldType> types = new TreeMap<String, FieldType>();
    private static Logger logger = Logger.getLogger(MolgenisFieldTypes.class);
    private static boolean init = false;

    private static void init() {
        if (!init) {
            MolgenisFieldTypes.addType(new BoolField());
            MolgenisFieldTypes.addType(new CategoricalField());
            MolgenisFieldTypes.addType(new DateField());
            MolgenisFieldTypes.addType(new DatetimeField());
            MolgenisFieldTypes.addType(new DecimalField());
            MolgenisFieldTypes.addType(new EnumField());
            MolgenisFieldTypes.addType(new EmailField());
            MolgenisFieldTypes.addType(new FileField());
            MolgenisFieldTypes.addType(new HtmlField());
            MolgenisFieldTypes.addType(new HyperlinkField());
            MolgenisFieldTypes.addType(new ImageField());
            MolgenisFieldTypes.addType(new IntField());
            MolgenisFieldTypes.addType(new LongField());
            MolgenisFieldTypes.addType(new MrefField());
            MolgenisFieldTypes.addType(new StringField());
            MolgenisFieldTypes.addType(new TextField());
            MolgenisFieldTypes.addType(new XrefField());
            init = true;
        }
    }

    public static void addType(FieldType ft) {
        types.put(ft.getClass().getSimpleName().toLowerCase(), ft);
    }

    public static HtmlInput<?> createInput(String type, String name, String xrefEntityClassName) throws HtmlInputException {
        return MolgenisFieldTypes.getType(type).createInput(name, xrefEntityClassName);
    }

    public static FieldType getType(String name) {
        MolgenisFieldTypes.init();
        FieldType fieldType = types.get(name + "field");
        if (fieldType != null) {
            try {
                return (FieldType)fieldType.getClass().newInstance();
            }
            catch (InstantiationException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
        logger.warn((Object)("couldn't get type for name '" + name + "'"));
        return null;
    }

    public static FieldType get(Field f) throws MolgenisModelException {
        MolgenisFieldTypes.init();
        try {
            FieldType ft = (FieldType)f.getType().getClass().newInstance();
            ft.setField(f);
            return ft;
        }
        catch (InstantiationException e) {
            logger.error((Object)e);
            throw new MolgenisModelException(e.getMessage());
        }
        catch (IllegalAccessException e) {
            logger.error((Object)e);
            throw new MolgenisModelException(e.getMessage());
        }
    }

    public static FieldType getTypeBySqlTypesCode(int sqlCode) {
        switch (sqlCode) {
            case -5: {
                return new LongField();
            }
            case -6: 
            case 4: 
            case 5: {
                return new IntField();
            }
            case -7: 
            case 16: {
                return new BoolField();
            }
            case 91: {
                return new DateField();
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: {
                return new DecimalField();
            }
            case -16: 
            case -9: 
            case -3: 
            case -1: 
            case 1: 
            case 12: 
            case 2004: 
            case 2005: {
                return new StringField();
            }
            case 92: 
            case 93: {
                return new DatetimeField();
            }
        }
        logger.error((Object)("UNKNOWN sql code: " + sqlCode));
        return null;
    }

    public static enum FieldTypeEnum {
        BOOL,
        CATEGORICAL,
        DATE,
        DATE_TIME,
        DECIMAL,
        EMAIL,
        ENUM,
        FILE,
        HTML,
        HYPERLINK,
        IMAGE,
        INT,
        LONG,
        MREF,
        STRING,
        TEXT,
        XREF;

    }
}

