/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.simulation.jstats.distributions;

import cern.jet.stat.Gamma;
import nl.tudelft.simulation.jstats.distributions.DistContinuous;
import nl.tudelft.simulation.jstats.distributions.DistGamma;
import nl.tudelft.simulation.jstats.streams.StreamInterface;

public class DistPearson5
extends DistContinuous {
    private DistGamma dist;
    private double alpha;
    private double beta;

    public DistPearson5(StreamInterface stream, double alpha, double beta) {
        super(stream);
        if (!(alpha > 0.0) || !(beta > 0.0)) {
            throw new IllegalArgumentException("Error alpha <= 0.0 or beta <= 0.0");
        }
        this.alpha = alpha;
        this.beta = beta;
        this.dist = new DistGamma(stream, this.alpha, 1.0 / this.beta);
    }

    public double draw() {
        return 1.0 / this.dist.draw();
    }

    public double probDensity(double observation) {
        if (observation > 0.0) {
            return Math.pow(observation, -1.0 * (this.alpha + 1.0)) * Math.exp(-this.beta / observation) / (Math.pow(this.beta, -this.alpha) * Gamma.gamma((double)this.alpha));
        }
        return 0.0;
    }

    public String toString() {
        return "Pearson5(" + this.alpha + "," + this.beta + ")";
    }
}

