/*
 * Decompiled with CFR 0.152.
 */
package nl.javel.gisbeans.map.mapfile;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import nl.javel.gisbeans.io.esri.ShapeFile;
import nl.javel.gisbeans.map.AbstractAttribute;
import nl.javel.gisbeans.map.Attribute;
import nl.javel.gisbeans.map.AttributeInterface;
import nl.javel.gisbeans.map.Image;
import nl.javel.gisbeans.map.ImageInterface;
import nl.javel.gisbeans.map.Layer;
import nl.javel.gisbeans.map.LayerInterface;
import nl.javel.gisbeans.map.Legend;
import nl.javel.gisbeans.map.LegendInterface;
import nl.javel.gisbeans.map.Map;
import nl.javel.gisbeans.map.MapInterface;
import nl.javel.gisbeans.map.ReferenceMap;
import nl.javel.gisbeans.map.ReferenceMapInterface;
import nl.javel.gisbeans.map.Scalebar;
import nl.javel.gisbeans.map.ScalebarInterface;
import nl.javel.gisbeans.map.StaticAttribute;
import nl.tudelft.simulation.language.io.URLResource;
import org.apache.xerces.parsers.DOMParser;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.Namespace;
import org.jdom.input.DOMBuilder;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public final class MapFileXMLParser {
    public static final URL MAPFILE_SCHEMA = URLResource.getResource((String)"/mapfile.xsd");

    public static MapInterface parseMapFile(URL url) throws IOException {
        try {
            Map map = new Map();
            DOMParser domParser = new DOMParser();
            domParser.setFeature("http://xml.org/sax/features/validation", true);
            domParser.setFeature("http://apache.org/xml/features/validation/schema", true);
            domParser.setProperty("http://apache.org/xml/properties/schema/external-schemaLocation", (Object)("http://www.javel.nl/gisbeans " + MAPFILE_SCHEMA.toExternalForm()));
            domParser.setErrorHandler((ErrorHandler)new ValidHandler());
            domParser.parse(url.toExternalForm());
            org.w3c.dom.Document document = domParser.getDocument();
            DOMBuilder builder = new DOMBuilder();
            Document jdomDocument = builder.build(document);
            Element xmlMapFileElement = jdomDocument.getRootElement();
            Element element = null;
            Namespace nameSpace = xmlMapFileElement.getNamespace();
            map.setName(xmlMapFileElement.getChildText("name"));
            element = xmlMapFileElement.getChild("units");
            if (element != null) {
                map.setUnits(MapFileXMLParser.parseUnits(element));
            }
            double[] extent = new double[]{new Double(xmlMapFileElement.getChild("extent").getChildText("minX")), new Double(xmlMapFileElement.getChild("extent").getChildText("minY")), new Double(xmlMapFileElement.getChild("extent").getChildText("maxX")), new Double(xmlMapFileElement.getChild("extent").getChildText("maxY"))};
            map.setExtent(new Rectangle2D.Double(extent[0], extent[1], extent[2] - extent[0], extent[3] - extent[1]));
            element = xmlMapFileElement.getChild("image", nameSpace);
            if (element != null) {
                map.setImage(MapFileXMLParser.parseImage(element, nameSpace));
            }
            if ((element = xmlMapFileElement.getChild("referenceMap", nameSpace)) != null) {
                map.setReferenceMap(MapFileXMLParser.parseReferenceMap(element));
            }
            List layerElements = xmlMapFileElement.getChildren("layer", nameSpace);
            ArrayList<LayerInterface> layers = new ArrayList<LayerInterface>();
            Iterator iterator = layerElements.iterator();
            while (iterator.hasNext()) {
                Element layerElement = (Element)iterator.next();
                layers.add(MapFileXMLParser.parseLayer(layerElement));
            }
            map.setLayers(layers);
            return map;
        }
        catch (Exception exception) {
            throw new IOException(exception.getMessage());
        }
    }

    private static int getColumnNumber(String[] columnNames, String columnName) {
        int i = 0;
        while (i < columnNames.length) {
            if (columnNames[i].equalsIgnoreCase(columnName)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private static AttributeInterface parseAttribute(Element element, LayerInterface layer) throws IOException {
        AbstractAttribute result = null;
        if (element.getChild("textColumn") != null) {
            int textColumnNumber = MapFileXMLParser.getColumnNumber(layer.getDataSource().getColumnNames(), element.getChildText("textColumn"));
            int angleColumnNumber = -1;
            if (element.getChild("degreesColumn") != null) {
                angleColumnNumber = MapFileXMLParser.getColumnNumber(layer.getDataSource().getColumnNames(), element.getChildText("degreesColumn"));
                result = new Attribute(layer, 1, angleColumnNumber, textColumnNumber);
            } else if (element.getChild("radiansColumn") != null) {
                angleColumnNumber = MapFileXMLParser.getColumnNumber(layer.getDataSource().getColumnNames(), element.getChildText("radiansColumn"));
                result = new Attribute(layer, 0, angleColumnNumber, textColumnNumber);
            } else {
                result = new Attribute(layer, 0, -1, textColumnNumber);
            }
        } else {
            double angle = 0.0;
            if (element.getChild("degrees") != null) {
                angle = Math.toRadians(new Double(element.getChildText("degrees")));
            }
            if (element.getChild("radians") != null) {
                angle = new Double(element.getChildText("radians"));
            }
            String value = "";
            if (element.getChild("text") != null) {
                value = element.getChildText("text");
            }
            result = new StaticAttribute(layer, angle, value);
        }
        if (element.getChild("minScale") != null) {
            result.setMinScale(new Integer(element.getChildText("minScale")).intValue());
        } else {
            result.setMinScale(layer.getMinScale());
        }
        if (element.getChild("maxScale") != null) {
            result.setMaxScale(new Integer(element.getChildText("maxScale")).intValue());
        } else {
            result.setMaxScale(layer.getMaxScale());
        }
        if (element.getChild("position") != null) {
            result.setPosition(MapFileXMLParser.parsePosition(element.getChild("position")));
        }
        if (element.getChild("font") != null) {
            result.setFont(MapFileXMLParser.parseFont(element.getChild("font")));
            result.setFontColor(MapFileXMLParser.parseColor(element.getChild("font").getChild("fontColor")));
        }
        return result;
    }

    private static boolean parseBoolean(Element element) throws IOException {
        try {
            boolean result = false;
            if (element.getText().equals("true")) {
                result = true;
            }
            return result;
        }
        catch (Exception exception) {
            throw new IOException(exception.getMessage());
        }
    }

    private static Color parseColor(Element element) throws IOException {
        try {
            int r = new Integer(element.getChildText("r"));
            int g = new Integer(element.getChildText("g"));
            int b = new Integer(element.getChildText("b"));
            if (element.getChildText("a") != null) {
                int a = new Integer(element.getChildText("a"));
                return new Color(r, g, b, a);
            }
            return new Color(r, g, b);
        }
        catch (Exception exception) {
            throw new IOException(exception.getMessage());
        }
    }

    private static Dimension parseDimension(Element element) throws IOException {
        try {
            int height = new Integer(element.getChildText("height"));
            int width = new Integer(element.getChildText("width"));
            return new Dimension(width, height);
        }
        catch (Exception exception) {
            throw new IOException(exception.getMessage());
        }
    }

    private static double[] parseExtent(Element element) throws IOException {
        try {
            double[] result = new double[4];
            result[0] = new Double(element.getChildText("minX"));
            result[1] = new Double(element.getChildText("minY"));
            result[3] = new Double(element.getChildText("maxX"));
            result[3] = new Double(element.getChildText("maxY"));
            return result;
        }
        catch (Exception exception) {
            throw new IOException(exception.getMessage());
        }
    }

    private static Font parseFont(Element element) throws IOException {
        try {
            String fontName = element.getChildText("fontName");
            int fontSize = new Integer(element.getChildText("fontSize"));
            return new Font(fontName, 0, fontSize);
        }
        catch (Exception exception) {
            throw new IOException(exception.getMessage());
        }
    }

    private static ImageInterface parseImage(Element element, Namespace nameSpace) throws IOException {
        Image result = new Image();
        try {
            if (element.getChild("backgroundColor") != null) {
                result.setBackgroundColor(MapFileXMLParser.parseColor(element.getChild("backgroundColor")));
            }
            if (element.getChild("legend", nameSpace) != null) {
                result.setLegend(MapFileXMLParser.parseLegend(element.getChild("legend", nameSpace)));
            }
            if (element.getChild("scalebar", nameSpace) != null) {
                result.setScalebar(MapFileXMLParser.parseScalebar(element.getChild("scalebar", nameSpace)));
            }
            if (element.getChild("size") != null) {
                result.setSize(MapFileXMLParser.parseDimension(element.getChild("size")));
            }
            return result;
        }
        catch (Exception exception) {
            throw new IOException(exception.getMessage());
        }
    }

    private static LayerInterface parseLayer(Element element) throws IOException {
        Layer result = new Layer();
        try {
            if (element.getChild("color") != null) {
                result.setColor(MapFileXMLParser.parseColor(element.getChild("color")));
            }
            if (element.getChild("data").getChild("shapeFile") != null) {
                String resource = element.getChild("data").getChildText("shapeFile");
                ShapeFile dataSource = new ShapeFile(URLResource.getResource((String)resource));
                if (element.getAttribute("cache") != null && element.getAttribute("cache").getValue().equals("false")) {
                    dataSource.setCache(false);
                } else {
                    dataSource.setCache(true);
                }
                result.setDataSource(dataSource);
            }
            if (element.getChild("data").getChild("SDI") != null) {
                throw new IOException("SDI not yet supported");
            }
            if (element.getChild("maxScale") != null) {
                result.setMaxScale(new Integer(element.getChildText("maxScale")));
            }
            if (element.getChild("minScale") != null) {
                result.setMinScale(new Integer(element.getChildText("minScale")));
            }
            result.setName(element.getChildText("name"));
            if (element.getChild("outlineColor") != null) {
                result.setOutlineColor(MapFileXMLParser.parseColor(element.getChild("outlineColor")));
            }
            if (element.getChild("status") != null) {
                result.setStatus(MapFileXMLParser.parseBoolean(element.getChild("status")));
            }
            if (element.getChild("transform") != null) {
                result.setTransform(MapFileXMLParser.parseBoolean(element.getChild("transform")));
            }
            List attributesElements = element.getChildren("attribute");
            ArrayList<AttributeInterface> attributes = new ArrayList<AttributeInterface>();
            Iterator iterator = attributesElements.iterator();
            while (iterator.hasNext()) {
                Element attributeElement = (Element)iterator.next();
                attributes.add(MapFileXMLParser.parseAttribute(attributeElement, result));
            }
            result.setAttributes(attributes);
            return result;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new IOException(exception.getMessage());
        }
    }

    private static LegendInterface parseLegend(Element element) throws IOException {
        Legend result = new Legend();
        try {
            if (element.getChild("backgroundColor") != null) {
                result.setOutlineColor(MapFileXMLParser.parseColor(element.getChild("backgroundColor")));
            }
            if (element.getChild("embed") != null) {
                result.setEmbed(MapFileXMLParser.parseBoolean(element.getChild("embed")));
            }
            if (element.getChild("font") != null) {
                result.setFont(MapFileXMLParser.parseFont(element.getChild("font")));
                result.setFontColor(MapFileXMLParser.parseColor(element.getChild("font").getChild("fontColor")));
            }
            if (element.getChild("outlineColor") != null) {
                result.setOutlineColor(MapFileXMLParser.parseColor(element.getChild("outlineColor")));
            }
            if (element.getChild("position") != null) {
                result.setPosition(MapFileXMLParser.parsePosition(element.getChild("position")));
            }
            if (element.getChild("size") != null) {
                result.setSize(MapFileXMLParser.parseDimension(element.getChild("size")));
            }
            if (element.getChild("status") != null) {
                result.setStatus(MapFileXMLParser.parseBoolean(element.getChild("status")));
            }
            return result;
        }
        catch (Exception exception) {
            throw new IOException(exception.getMessage());
        }
    }

    private static int parsePosition(Element element) {
        if (element.getText().equals("ul")) {
            return 0;
        }
        if (element.getText().equals("uc")) {
            return 1;
        }
        if (element.getText().equals("ur")) {
            return 2;
        }
        if (element.getText().equals("cl")) {
            return 3;
        }
        if (element.getText().equals("cc")) {
            return 4;
        }
        if (element.getText().equals("cr")) {
            return 5;
        }
        if (element.getText().equals("ll")) {
            return 6;
        }
        if (element.getText().equals("lc")) {
            return 7;
        }
        if (element.getText().equals("lr")) {
            return 8;
        }
        return 0;
    }

    private static ReferenceMapInterface parseReferenceMap(Element element) throws IOException {
        ReferenceMap result = new ReferenceMap();
        try {
            result.setImage(new URL(element.getChildText("image")));
            result.setExtent(MapFileXMLParser.parseExtent(element.getChild("extent")));
            if (element.getChild("outlineColor") != null) {
                result.setOutlineColor(MapFileXMLParser.parseColor(element.getChild("outlineColor")));
            }
            if (element.getChild("size") != null) {
                result.setSize(MapFileXMLParser.parseDimension(element.getChild("size")));
            }
            if (element.getChild("status") != null) {
                result.setStatus(MapFileXMLParser.parseBoolean(element.getChild("status")));
            }
            return result;
        }
        catch (Exception exception) {
            throw new IOException(exception.getMessage());
        }
    }

    private static ScalebarInterface parseScalebar(Element element) throws IOException {
        Scalebar result = new Scalebar();
        try {
            if (element.getChild("backgroundColor") != null) {
                result.setBackgroundColor(MapFileXMLParser.parseColor(element.getChild("backgroundColor")));
            }
            if (element.getChild("color") != null) {
                result.setColor(MapFileXMLParser.parseColor(element.getChild("color")));
            }
            if (element.getChild("embed") != null) {
                result.setEmbed(MapFileXMLParser.parseBoolean(element.getChild("embed")));
            }
            if (element.getChild("font") != null) {
                result.setFont(MapFileXMLParser.parseFont(element.getChild("font")));
                result.setFontColor(MapFileXMLParser.parseColor(element.getChild("font").getChild("fontColor")));
            }
            if (element.getChild("intervals") != null) {
                result.setIntervals(new Integer(element.getChildText("intervals")));
            }
            if (element.getChild("position") != null) {
                result.setPosition(MapFileXMLParser.parsePosition(element.getChild("position")));
            }
            if (element.getChild("size") != null) {
                result.setSize(MapFileXMLParser.parseDimension(element.getChild("size")));
            }
            if (element.getChild("status") != null) {
                result.setStatus(MapFileXMLParser.parseBoolean(element.getChild("status")));
            }
            if (element.getChild("units") != null) {
                result.setUnits(MapFileXMLParser.parseUnits(element.getChild("units")));
            }
            return result;
        }
        catch (Exception exception) {
            throw new IOException(exception.getMessage());
        }
    }

    private static int parseUnits(Element element) {
        if (element.getText().equals("feet")) {
            return 0;
        }
        if (element.getText().equals("dd")) {
            return 5;
        }
        if (element.getText().equals("inches")) {
            return 1;
        }
        if (element.getText().equals("kilometers")) {
            return 2;
        }
        if (element.getText().equals("meters")) {
            return 3;
        }
        if (element.getText().equals("miles")) {
            return 4;
        }
        return 3;
    }

    private static class ValidHandler
    extends DefaultHandler {
        ValidHandler() {
        }

        private String formatError(SAXParseException exception) {
            return "SAXParseException: \nsystemId=" + exception.getSystemId() + "\npublicId=" + exception.getSystemId() + "\nMessage=" + exception.getMessage() + "\nline,col=" + exception.getLineNumber() + "," + exception.getColumnNumber();
        }

        public void error(SAXParseException e) throws SAXException {
            throw new SAXException(this.formatError(e));
        }

        public void fatalError(SAXParseException e) throws SAXException {
            throw new SAXException(this.formatError(e));
        }
    }
}

