/*
 * Decompiled with CFR 0.152.
 */
package nl.javel.gisbeans.map;

import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.text.DecimalFormat;
import java.util.Iterator;
import java.util.List;
import nl.javel.gisbeans.geom.GisObject;
import nl.javel.gisbeans.geom.SerializableGeneralPath;
import nl.javel.gisbeans.geom.SerializableRectangle2D;
import nl.javel.gisbeans.map.AbstractAttribute;
import nl.javel.gisbeans.map.GraphicsException;
import nl.javel.gisbeans.map.ImageInterface;
import nl.javel.gisbeans.map.Layer;
import nl.javel.gisbeans.map.LayerInterface;
import nl.javel.gisbeans.map.MapInterface;
import nl.javel.gisbeans.map.ReferenceMapInterface;

public class Map
implements MapInterface {
    private Rectangle2D extent;
    private List layers;
    private ImageInterface image;
    private String name;
    private ReferenceMapInterface referenceMap;
    private int units;
    private final int RESOLUTION = 72;

    public void addLayer(LayerInterface layer) {
        this.layers.add(layer);
    }

    public Graphics2D drawLegend(Graphics2D graphics) {
        if (this.getImage().getLegend().isStatus()) {
            int space;
            graphics.setColor(this.getImage().getLegend().getBackgroundColor());
            graphics.fillRect(0, 0, (int)this.getImage().getLegend().getSize().getWidth(), (int)this.getImage().getLegend().getSize().getHeight());
            graphics.setColor(this.getImage().getLegend().getOutlineColor());
            graphics.drawRect(0, 0, (int)this.getImage().getLegend().getSize().getWidth(), (int)this.getImage().getLegend().getSize().getHeight());
            int position = space = 2;
            int dPosition = (int)Math.floor((this.getImage().getLegend().getSize().getHeight() - (double)(2 * space)) / (double)(1 + this.getLayers().size()));
            int nr = 0;
            Iterator i = this.getLayers().iterator();
            while (i.hasNext()) {
                Layer layer = (Layer)i.next();
                graphics.setColor(layer.getColor());
                graphics.fillRect(space, position, dPosition - space, dPosition - space);
                if (layer.getOutlineColor() != null) {
                    graphics.setColor(layer.getOutlineColor());
                }
                graphics.drawRect(space, position, dPosition - space - 1, dPosition - space - 1);
                graphics.setFont(this.getImage().getLegend().getFont());
                FontMetrics fm = graphics.getFontMetrics(this.getImage().getLegend().getFont());
                while (fm.getStringBounds(layer.getName(), graphics).getWidth() > this.getImage().getLegend().getSize().getWidth() - (double)(2 * space) - (double)dPosition || fm.getStringBounds(layer.getName(), graphics).getHeight() > (double)(dPosition - 2 * space)) {
                    graphics.setFont(new Font(this.getImage().getLegend().getFont().getFontName(), 0, graphics.getFont().getSize() - 1));
                    fm = graphics.getFontMetrics(graphics.getFont());
                }
                graphics.setColor(this.getImage().getLegend().getFontColor());
                graphics.drawString(layer.getName(), 4 + dPosition, dPosition + position - 4);
                position = nr++ * (int)(this.getImage().getLegend().getSize().getHeight() / (double)this.getLayers().size());
            }
        }
        return graphics;
    }

    public Graphics2D drawMap(Graphics2D graphics) throws GraphicsException {
        graphics.setColor(this.getImage().getBackgroundColor());
        graphics.fillRect(0, 0, (int)this.getImage().getSize().getWidth(), (int)this.getImage().getSize().getHeight());
        AffineTransform transform = new AffineTransform();
        transform.scale(this.getImage().getSize().getWidth() / this.extent.getWidth(), -this.getImage().getSize().getHeight() / this.extent.getHeight());
        transform.translate(-this.extent.getX(), -this.extent.getY() - this.extent.getHeight());
        AffineTransform antiTransform = null;
        try {
            antiTransform = transform.createInverse();
        }
        catch (NoninvertibleTransformException e) {
            e.printStackTrace();
        }
        double scale = this.getScale();
        graphics.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        Iterator i = this.getLayers().iterator();
        while (i.hasNext()) {
            Layer layer = (Layer)i.next();
            try {
                if (!layer.isStatus() || !((double)layer.getMaxScale() < scale) || !((double)layer.getMinScale() > scale)) continue;
                List shapes = layer.getDataSource().getShapes(this.extent);
                SerializableGeneralPath shape = null;
                int shapeNumber = 0;
                Iterator shapeIterator = shapes.iterator();
                while (shapeIterator.hasNext()) {
                    GisObject gisObject = (GisObject)shapeIterator.next();
                    if (layer.getDataSource().getType() == 1) {
                        shape = new SerializableGeneralPath();
                        Point2D point = (Point2D)gisObject.getShape();
                        shape.moveTo((float)point.getX(), (float)point.getY());
                    } else {
                        shape = (SerializableGeneralPath)gisObject.getShape();
                    }
                    if (layer.isTransform()) {
                        shape.transform(transform);
                    }
                    graphics.setColor(layer.getColor());
                    if (layer.getDataSource().getType() == 0) {
                        graphics.fill(shape);
                    }
                    if (layer.getOutlineColor() != null) {
                        graphics.setColor(layer.getOutlineColor());
                    }
                    graphics.draw(shape);
                    Iterator iA = layer.getAttributes().iterator();
                    while (iA.hasNext()) {
                        AbstractAttribute attribute = (AbstractAttribute)iA.next();
                        if (!(attribute.getMaxScale() < scale) || !(attribute.getMinScale() > scale)) continue;
                        graphics.setColor(attribute.getFontColor());
                        graphics.setFont(attribute.getFont());
                        if (layer.isTransform()) {
                            graphics.translate(shape.getBounds2D().getCenterX(), shape.getBounds2D().getCenterY());
                            graphics.rotate(Math.PI * 2 - attribute.getAngle(shapeNumber));
                        }
                        FontMetrics fm = graphics.getFontMetrics(attribute.getFont());
                        int[] xy = new int[2];
                        switch (attribute.getPosition()) {
                            case 0: {
                                xy[0] = (int)(-fm.getStringBounds(attribute.getValue(shapeNumber), graphics).getWidth());
                                xy[1] = 0;
                                break;
                            }
                            case 1: {
                                xy[0] = (int)(-fm.getStringBounds(attribute.getValue(shapeNumber), graphics).getWidth()) / 2;
                                xy[1] = 0;
                                break;
                            }
                            case 2: {
                                xy[0] = 0;
                                xy[1] = 0;
                                break;
                            }
                            case 3: {
                                xy[0] = (int)(-fm.getStringBounds(attribute.getValue(shapeNumber), graphics).getWidth());
                                xy[1] = (int)(-fm.getStringBounds(attribute.getValue(shapeNumber), graphics).getHeight()) / 2;
                                break;
                            }
                            case 4: {
                                xy[0] = (int)(-fm.getStringBounds(attribute.getValue(shapeNumber), graphics).getWidth()) / 2;
                                xy[1] = (int)(-fm.getStringBounds(attribute.getValue(shapeNumber), graphics).getHeight()) / 2;
                                break;
                            }
                            case 5: {
                                xy[0] = 0;
                                xy[1] = (int)(-fm.getStringBounds(attribute.getValue(shapeNumber), graphics).getHeight()) / 2;
                                break;
                            }
                            case 6: {
                                xy[0] = (int)(-fm.getStringBounds(attribute.getValue(shapeNumber), graphics).getWidth());
                                xy[1] = (int)(-fm.getStringBounds(attribute.getValue(shapeNumber), graphics).getHeight());
                                break;
                            }
                            case 7: {
                                xy[0] = (int)(-fm.getStringBounds(attribute.getValue(shapeNumber), graphics).getWidth()) / 2;
                                xy[1] = (int)(-fm.getStringBounds(attribute.getValue(shapeNumber), graphics).getHeight());
                                break;
                            }
                            case 8: {
                                xy[0] = 0;
                                xy[1] = (int)(-fm.getStringBounds(attribute.getValue(shapeNumber), graphics).getHeight());
                                break;
                            }
                            default: {
                                xy[0] = 0;
                                xy[1] = 0;
                            }
                        }
                        graphics.drawString(attribute.getValue(shapeNumber), xy[0], xy[1]);
                        if (!layer.isTransform()) continue;
                        graphics.rotate(-(Math.PI * 2 - attribute.getAngle(shapeNumber)));
                        graphics.translate(-shape.getBounds2D().getCenterX(), -shape.getBounds2D().getCenterY());
                    }
                    if (layer.isTransform()) {
                        shape.transform(antiTransform);
                    }
                    ++shapeNumber;
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                throw new GraphicsException(exception.getMessage());
            }
        }
        return graphics;
    }

    public Graphics2D drawReferenceMap(Graphics2D graphics) {
        return graphics;
    }

    public Graphics2D drawScalebar(Graphics2D graphics) {
        if (this.getImage().getScalebar().isStatus()) {
            graphics.setColor(this.getImage().getScalebar().getBackgroundColor());
            graphics.fillRect(0, 0, (int)this.getImage().getScalebar().getSize().getWidth(), (int)this.getImage().getScalebar().getSize().getHeight());
            graphics.setColor(this.getImage().getScalebar().getColor());
            graphics.drawRect(0, 0, (int)this.getImage().getScalebar().getSize().getWidth() - 1, (int)this.getImage().getScalebar().getSize().getHeight() - 1);
            graphics.drawRect(0, 0, (int)this.getImage().getScalebar().getSize().getWidth() - 1, (int)this.getImage().getScalebar().getSize().getHeight() / 2);
            graphics.setFont(this.getImage().getScalebar().getFont());
            graphics.setColor(this.getImage().getScalebar().getFontColor());
            String units = new String();
            switch (this.getImage().getScalebar().getUnits()) {
                case 0: {
                    units = " ft.";
                    break;
                }
                case 1: {
                    units = " in.";
                    break;
                }
                case 2: {
                    units = " km.";
                    break;
                }
                case 3: {
                    units = " m.";
                    break;
                }
                case 4: {
                    units = " mi.";
                    break;
                }
                case 5: {
                    units = " dd.";
                    break;
                }
                default: {
                    units = " m.";
                }
            }
            DecimalFormat formatter = new DecimalFormat("#.00");
            double[] factor = new double[]{0.3048, 0.0254, 1000.0, 1.0, 1609.34, 111119.0};
            String scale = String.valueOf(formatter.format(this.getImage().getScalebar().getSize().getWidth() / this.getImage().getSize().getWidth() * this.getExtent().getWidth() * (factor[this.getUnits()] / factor[this.getImage().getScalebar().getUnits()]))) + units;
            FontMetrics fm = graphics.getFontMetrics(this.getImage().getScalebar().getFont());
            while (fm.getStringBounds(String.valueOf(formatter.format(this.getUnitImageRatio())) + units, graphics).getWidth() > this.getImage().getScalebar().getSize().getWidth() || fm.getStringBounds(String.valueOf(formatter.format(this.getUnitImageRatio())) + units, graphics).getHeight() > this.getImage().getScalebar().getSize().getHeight() / 2.0) {
                graphics.setFont(new Font(this.getImage().getScalebar().getFont().getFontName(), 0, graphics.getFont().getSize() - 1));
                fm = graphics.getFontMetrics(graphics.getFont());
            }
            graphics.drawString(scale, (int)this.getImage().getScalebar().getSize().getWidth() - fm.stringWidth(scale) - 1, (int)this.getImage().getScalebar().getSize().getHeight() - 2);
            int x = 0;
            int i = 0;
            while (i <= this.getImage().getScalebar().getIntervals()) {
                if (i % 2 != 0) {
                    graphics.setColor(this.getImage().getScalebar().getColor());
                    graphics.fillRect(x, 0, (int)this.getImage().getScalebar().getSize().getWidth() / this.getImage().getScalebar().getIntervals(), (int)this.getImage().getScalebar().getSize().getHeight() / 2);
                    x += (int)this.getImage().getScalebar().getSize().getWidth() / this.getImage().getScalebar().getIntervals() * 2;
                }
                ++i;
            }
        }
        return graphics;
    }

    public Rectangle2D getExtent() {
        return this.extent;
    }

    public ImageInterface getImage() {
        return this.image;
    }

    public List getLayers() {
        return this.layers;
    }

    public String getName() {
        return this.name;
    }

    public double getScale() {
        return this.getImage().getSize().getWidth() / (2.54 * (double)this.RESOLUTION) * this.extent.getWidth();
    }

    public ReferenceMapInterface getReferenceMap() {
        return this.referenceMap;
    }

    public double getUnitImageRatio() {
        return Math.min(this.extent.getWidth() / this.image.getSize().getWidth(), this.extent.getHeight() / this.image.getSize().getHeight());
    }

    public int getUnits() {
        return this.units;
    }

    public void setExtent(Rectangle2D extent) {
        this.extent = extent;
    }

    public void setImage(ImageInterface image) {
        this.image = image;
    }

    public void setLayers(List layers) {
        this.layers = layers;
    }

    public void setLayer(int index, LayerInterface layer) {
        this.layers.set(index, layer);
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setReferenceMap(ReferenceMapInterface referenceMap) {
        this.referenceMap = referenceMap;
    }

    public void setUnits(int units) {
        this.units = units;
    }

    public void zoom(double zoomFactor) {
        if (zoomFactor == 0.0) {
            zoomFactor = 1.0;
        }
        double maxX = this.getUnitImageRatio() * this.getImage().getSize().getWidth() + this.extent.getMinX();
        double maxY = this.getUnitImageRatio() * this.getImage().getSize().getHeight() + this.extent.getMinY();
        double centerX = (maxX - this.extent.getMinX()) / 2.0 + this.extent.getMinX();
        double centerY = (maxY - this.extent.getMinY()) / 2.0 + this.extent.getMinY();
        double width = 1.0 / zoomFactor * (maxX - this.extent.getMinX());
        double height = 1.0 / zoomFactor * (maxY - this.extent.getMinY());
        this.extent = new Rectangle2D.Double(centerX - 0.5 * width, centerY - 0.5 * height, width, height);
    }

    public void zoomPoint(Point2D pixelPosition, double zoomFactor) {
        if (zoomFactor == 0.0) {
            zoomFactor = 1.0;
        }
        double maxX = this.getUnitImageRatio() * this.getImage().getSize().getWidth() + this.extent.getMinX();
        double maxY = this.getUnitImageRatio() * this.getImage().getSize().getHeight() + this.extent.getMinY();
        double centerX = pixelPosition.getX() / this.getImage().getSize().getWidth() * (maxX - this.extent.getMinX()) + this.extent.getMinX();
        double centerY = maxY - pixelPosition.getY() / this.getImage().getSize().getHeight() * (maxY - this.extent.getMinY());
        double width = 1.0 / zoomFactor * (maxX - this.extent.getMinX());
        double height = 1.0 / zoomFactor * (maxY - this.getExtent().getMinY());
        this.extent = new Rectangle2D.Double(centerX - 0.5 * width, centerY - 0.5 * height, width, height);
    }

    public void zoomRectangle(SerializableRectangle2D rectangle) {
        double maxX = this.getUnitImageRatio() * this.getImage().getSize().getWidth() + this.extent.getMinX();
        double maxY = this.getUnitImageRatio() * this.getImage().getSize().getHeight() + this.extent.getMinY();
        double width = maxX - this.extent.getMinX();
        double height = maxY - this.extent.getMinY();
        double minX = this.extent.getMinX() + rectangle.getMinX() / this.getImage().getSize().getWidth() * width;
        double minY = this.extent.getMinY() + (this.getImage().getSize().getHeight() - rectangle.getMaxY()) / this.getImage().getSize().getHeight() * height;
        maxX = minX + rectangle.getWidth() / this.getImage().getSize().getWidth() * width;
        maxY = minY + (this.getImage().getSize().getHeight() - rectangle.getHeight()) / this.getImage().getSize().getHeight() * height;
        this.extent = new Rectangle2D.Double(minX, minY, maxX - minX, maxY - minY);
    }
}

