/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.genotype.vcf;

import java.util.ArrayList;
import org.molgenis.genotype.vcf.VcfSampleGenotype;

public class VcfSampleGenotypeParser {
    private static final char PHASED_SEPARATOR = '|';
    private static final char UNPHASED_SEPARATOR = '/';
    private String genotype;

    public VcfSampleGenotypeParser(String genotype) {
        if (genotype == null) {
            throw new IllegalArgumentException("Genotype is null");
        }
        this.genotype = genotype;
    }

    public VcfSampleGenotype parse() {
        ArrayList<Character> alleleIndices = new ArrayList<Character>(2);
        ArrayList<Boolean> phasing = new ArrayList<Boolean>();
        block4: for (char c : this.genotype.toCharArray()) {
            switch (c) {
                case '|': {
                    phasing.add(true);
                    continue block4;
                }
                case '/': {
                    phasing.add(false);
                    continue block4;
                }
                default: {
                    alleleIndices.add(Character.valueOf(c));
                }
            }
        }
        return new VcfSampleGenotype(alleleIndices, phasing);
    }
}

