/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.genotype.vcf;

import com.google.common.collect.Lists;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.molgenis.genotype.vcf.VcfAlt;
import org.molgenis.genotype.vcf.VcfContig;
import org.molgenis.genotype.vcf.VcfFormat;
import org.molgenis.genotype.vcf.VcfHeaderParser;
import org.molgenis.genotype.vcf.VcfInfo;
import org.molgenis.genotype.vcf.VcfRecord;
import org.molgenis.genotype.vcf.VcfSample;
import org.molgenis.io.TupleReader;
import org.molgenis.io.csv.CsvReader;
import org.molgenis.io.processor.CellProcessor;
import org.molgenis.util.tuple.Tuple;

public class VcfReader
implements TupleReader {
    private static final Charset CHARSET_UTF8 = Charset.forName("UTF-8");
    private static final List<String> NORMAL_COL_NAMES = Arrays.asList("#CHROM", "POS", "ID", "REF", "ALT", "QUAL", "FILTER", "INFO", "FORMAT", "");
    private List<String> headers = new ArrayList<String>();
    private final CsvReader csvReader;

    public VcfReader(InputStream vcfInputStream) throws IOException {
        BufferedReader br = new BufferedReader(new InputStreamReader(vcfInputStream, CHARSET_UTF8));
        br.mark(vcfInputStream.available());
        this.headers = this.readHeaders(br);
        br.reset();
        for (int i = 0; i < this.headers.size(); ++i) {
            br.readLine();
        }
        this.csvReader = new CsvReader((Reader)br, '\t', true);
    }

    public List<String> getSampleNames() throws IOException {
        ArrayList<String> sampleNames = new ArrayList<String>();
        Iterator<String> it = this.colNamesIterator();
        while (it.hasNext()) {
            String colName = it.next();
            if (NORMAL_COL_NAMES.contains(colName)) continue;
            sampleNames.add(colName);
        }
        return Collections.unmodifiableList(sampleNames);
    }

    public List<String> getColNames() throws IOException {
        return Collections.unmodifiableList(Lists.newArrayList(this.colNamesIterator()));
    }

    public List<VcfInfo> getInfos() {
        ArrayList<VcfInfo> infos = new ArrayList<VcfInfo>();
        for (String header : this.headers) {
            if (!header.startsWith("##INFO")) continue;
            Tuple tuple = new VcfHeaderParser(header).parse();
            VcfInfo info = new VcfInfo(tuple);
            infos.add(info);
        }
        return infos;
    }

    public List<VcfFormat> getFormats() {
        ArrayList<VcfFormat> formats = new ArrayList<VcfFormat>();
        for (String header : this.headers) {
            if (!header.startsWith("##FORMAT")) continue;
            Tuple tuple = new VcfHeaderParser(header).parse();
            VcfFormat format = new VcfFormat(tuple);
            formats.add(format);
        }
        return formats;
    }

    public List<VcfSample> getSamples() {
        ArrayList<VcfSample> samples = new ArrayList<VcfSample>();
        for (String header : this.headers) {
            if (!header.startsWith("##SAMPLE")) continue;
            Tuple tuple = new VcfHeaderParser(header).parse();
            samples.add(new VcfSample(tuple));
        }
        return samples;
    }

    public List<VcfContig> getContigs() {
        ArrayList<VcfContig> contigs = new ArrayList<VcfContig>();
        for (String header : this.headers) {
            if (!header.startsWith("##contig")) continue;
            Tuple tuple = new VcfHeaderParser(header).parse();
            VcfContig contig = new VcfContig(tuple);
            contigs.add(contig);
        }
        return contigs;
    }

    public List<VcfAlt> getAlts() {
        ArrayList<VcfAlt> alts = new ArrayList<VcfAlt>();
        for (String header : this.headers) {
            if (!header.startsWith("##ALT")) continue;
            Tuple tuple = new VcfHeaderParser(header).parse();
            alts.add(new VcfAlt(tuple));
        }
        return alts;
    }

    public Iterator<VcfRecord> recordIterator() {
        return new VcfRecordIterator(this.iterator());
    }

    public void close() throws IOException {
        this.csvReader.close();
    }

    public Iterator<Tuple> iterator() {
        return this.csvReader.iterator();
    }

    public boolean hasColNames() {
        return true;
    }

    public Iterator<String> colNamesIterator() throws IOException {
        return this.csvReader.colNamesIterator();
    }

    public void addCellProcessor(CellProcessor cellProcessor) {
        this.csvReader.addCellProcessor(cellProcessor);
    }

    private List<String> readHeaders(BufferedReader br) throws IOException {
        ArrayList<String> headers = new ArrayList<String>();
        String header = br.readLine();
        while (header != null && header.startsWith("##")) {
            headers.add(header);
            header = br.readLine();
        }
        return headers;
    }

    private static class VcfRecordIterator
    implements Iterator<VcfRecord> {
        private final Iterator<Tuple> tupleIterator;

        public VcfRecordIterator(Iterator<Tuple> tupleIterator) {
            this.tupleIterator = tupleIterator;
        }

        @Override
        public boolean hasNext() {
            return this.tupleIterator.hasNext();
        }

        @Override
        public VcfRecord next() {
            Tuple tuple = this.tupleIterator.next();
            return new VcfRecord(tuple);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

