/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.genotype.vcf;

import org.molgenis.util.tuple.Tuple;

public class VcfFormat {
    private String id;
    private Type type;
    private String number;
    private String description;

    public VcfFormat(Tuple settings) {
        this.id = settings.getString("ID");
        this.number = settings.getString("Number");
        this.type = Type.getValue(settings.getString("Type"));
        this.description = settings.getString("Description");
    }

    public VcfFormat(String id, Type type, String number, String description) {
        this.id = id;
        this.type = type;
        this.number = number;
        this.description = description;
    }

    public String getId() {
        return this.id;
    }

    public Type getType() {
        return this.type;
    }

    public String getNumber() {
        return this.number;
    }

    public String getDescription() {
        return this.description;
    }

    public String toString() {
        return String.format("VcfFormat(ID=%s,Number=%s,Type=%s,Description=\"%s\")", new Object[]{this.getId(), this.getNumber(), this.getType(), this.getDescription()});
    }

    public static enum Type {
        INTEGER,
        FLOAT,
        CHARACTER,
        STRING,
        UNKNOWN;


        public static Type getValue(String value) {
            if ("Integer".equals(value)) {
                return INTEGER;
            }
            if ("Float".equals(value)) {
                return FLOAT;
            }
            if ("Character".equals(value)) {
                return CHARACTER;
            }
            if ("String".equals(value)) {
                return STRING;
            }
            return UNKNOWN;
        }
    }
}

