/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.genotype.variantFilter;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.molgenis.genotype.AbstractRandomAccessGenotypeData;
import org.molgenis.genotype.RandomAccessGenotypeData;
import org.molgenis.genotype.Sample;
import org.molgenis.genotype.Sequence;
import org.molgenis.genotype.annotation.Annotation;
import org.molgenis.genotype.annotation.SampleAnnotation;
import org.molgenis.genotype.variant.GeneticVariant;
import org.molgenis.genotype.variantFilter.VariantFilter;
import org.molgenis.genotype.variantFilter.VariantFilterIterable;
import org.molgenis.genotype.variantFilter.VariantFilterIterator;
import org.molgenis.genotype.variantFilter.VariantFilterableGenotypeData;

public class VariantFilterableGenotypeDataDecorator
extends AbstractRandomAccessGenotypeData
implements VariantFilterableGenotypeData {
    private final RandomAccessGenotypeData originalGenotypeData;
    private final VariantFilter variantFilter;

    public VariantFilterableGenotypeDataDecorator(RandomAccessGenotypeData originalGenotypeData, VariantFilter variantFilter) {
        if (variantFilter == null) {
            throw new IllegalArgumentException("Variant filter can not be null");
        }
        this.originalGenotypeData = originalGenotypeData;
        this.variantFilter = variantFilter;
    }

    @Override
    public List<String> getSeqNames() {
        return this.originalGenotypeData.getSeqNames();
    }

    @Override
    public Iterable<Sequence> getSequences() {
        return this.originalGenotypeData.getSequences();
    }

    @Override
    public Sequence getSequenceByName(String name) {
        return this.originalGenotypeData.getSequenceByName(name);
    }

    @Override
    public Iterable<GeneticVariant> getVariantsByPos(String seqName, int startPos) {
        return this.createFilterIterable(this.originalGenotypeData.getVariantsByPos(seqName, startPos));
    }

    @Override
    public GeneticVariant getSnpVariantByPos(String seqName, int startPos) {
        GeneticVariant variant = this.originalGenotypeData.getSnpVariantByPos(seqName, startPos);
        if (variant == null) {
            return null;
        }
        if (this.variantFilter.doesVariantPassFilter(variant)) {
            return variant;
        }
        return null;
    }

    @Override
    public Iterable<GeneticVariant> getSequenceGeneticVariants(String seqName) {
        return this.createFilterIterable(this.originalGenotypeData.getSequenceGeneticVariants(seqName));
    }

    @Override
    public Iterable<GeneticVariant> getVariantsByRange(String seqName, int rangeStart, int rangeEnd) {
        return this.createFilterIterable(this.originalGenotypeData.getVariantsByRange(seqName, rangeStart, rangeEnd));
    }

    @Override
    public List<Annotation> getVariantAnnotations() {
        return this.originalGenotypeData.getVariantAnnotations();
    }

    @Override
    public Annotation getVariantAnnotation(String annotationId) {
        return this.originalGenotypeData.getVariantAnnotation(annotationId);
    }

    @Override
    public List<SampleAnnotation> getSampleAnnotations() {
        return this.originalGenotypeData.getSampleAnnotations();
    }

    @Override
    public Annotation getSampleAnnotation(String annotationId) {
        return this.originalGenotypeData.getSampleAnnotation(annotationId);
    }

    @Override
    public List<Sample> getSamples() {
        return this.originalGenotypeData.getSamples();
    }

    @Override
    public Iterator<GeneticVariant> iterator() {
        return this.createFilterIterable(this.originalGenotypeData).iterator();
    }

    private Iterable<GeneticVariant> createFilterIterable(Iterable<GeneticVariant> originalIterable) {
        return new VariantFilterIterable(new VariantFilterIterator(originalIterable.iterator(), this.variantFilter));
    }

    @Override
    public void setFilter(VariantFilter filter) {
        if (this.variantFilter == null) {
            throw new IllegalArgumentException("Variant filter can not be null");
        }
    }

    @Override
    public VariantFilter getFilter() {
        return this.variantFilter;
    }

    @Override
    public void close() throws IOException {
        this.originalGenotypeData.close();
    }

    @Override
    public Map<String, Annotation> getVariantAnnotationsMap() {
        return this.originalGenotypeData.getVariantAnnotationsMap();
    }

    @Override
    public Map<String, SampleAnnotation> getSampleAnnotationsMap() {
        return this.originalGenotypeData.getSampleAnnotationsMap();
    }
}

