/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.genotype.variantFilter;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.molgenis.genotype.AbstractRandomAccessGenotypeData;
import org.molgenis.genotype.RandomAccessGenotypeData;
import org.molgenis.genotype.Sample;
import org.molgenis.genotype.Sequence;
import org.molgenis.genotype.annotation.Annotation;
import org.molgenis.genotype.annotation.SampleAnnotation;
import org.molgenis.genotype.variant.GeneticVariant;
import org.molgenis.genotype.variantFilter.VariantFilterIterable;
import org.molgenis.genotype.variantFilter.VariantFilterIterator;
import org.molgenis.genotype.variantFilter.VariantQcChecker;

public class RandomAccessGenotypeDataVariantQc
extends AbstractRandomAccessGenotypeData {
    private final RandomAccessGenotypeData originalGenotypeData;
    private final VariantQcChecker qcChecker;

    public RandomAccessGenotypeDataVariantQc(RandomAccessGenotypeData originalGenotypeData, VariantQcChecker qcChecker) {
        this.originalGenotypeData = originalGenotypeData;
        this.qcChecker = qcChecker;
    }

    public RandomAccessGenotypeDataVariantQc(RandomAccessGenotypeData originalGenotypeData) {
        this.originalGenotypeData = originalGenotypeData;
        this.qcChecker = new VariantQcChecker(1.0f, 0.0f, 0.0);
    }

    public void setMafCutoff(float maf) {
        this.qcChecker.setMafCutoff(maf);
    }

    public void setHweCutoff(double hwe) {
        this.qcChecker.setHweCutoff(hwe);
    }

    public void setCallRateCutoff(double callRate) {
        this.qcChecker.setCallRateCutoff(callRate);
    }

    @Override
    public List<String> getSeqNames() {
        return this.originalGenotypeData.getSeqNames();
    }

    @Override
    public Iterable<Sequence> getSequences() {
        return this.originalGenotypeData.getSequences();
    }

    @Override
    public Sequence getSequenceByName(String name) {
        return this.originalGenotypeData.getSequenceByName(name);
    }

    @Override
    public Iterable<GeneticVariant> getVariantsByPos(String seqName, int startPos) {
        return this.createQcIterable(this.originalGenotypeData.getVariantsByPos(seqName, startPos));
    }

    @Override
    public GeneticVariant getSnpVariantByPos(String seqName, int startPos) {
        GeneticVariant variant = this.originalGenotypeData.getSnpVariantByPos(seqName, startPos);
        if (variant == null) {
            return null;
        }
        if (this.qcChecker.doesVariantPassFilter(variant)) {
            return variant;
        }
        return null;
    }

    @Override
    public Iterable<GeneticVariant> getSequenceGeneticVariants(String seqName) {
        return this.createQcIterable(this.originalGenotypeData.getSequenceGeneticVariants(seqName));
    }

    @Override
    public Iterable<GeneticVariant> getVariantsByRange(String seqName, int rangeStart, int rangeEnd) {
        return this.createQcIterable(this.originalGenotypeData.getVariantsByRange(seqName, rangeStart, rangeEnd));
    }

    @Override
    public List<Annotation> getVariantAnnotations() {
        return this.originalGenotypeData.getVariantAnnotations();
    }

    @Override
    public Annotation getVariantAnnotation(String annotationId) {
        return this.originalGenotypeData.getVariantAnnotation(annotationId);
    }

    @Override
    public List<SampleAnnotation> getSampleAnnotations() {
        return this.originalGenotypeData.getSampleAnnotations();
    }

    @Override
    public Annotation getSampleAnnotation(String annotationId) {
        return this.originalGenotypeData.getSampleAnnotation(annotationId);
    }

    @Override
    public List<Sample> getSamples() {
        return this.originalGenotypeData.getSamples();
    }

    @Override
    public Iterator<GeneticVariant> iterator() {
        return this.createQcIterable(this.originalGenotypeData).iterator();
    }

    private Iterable<GeneticVariant> createQcIterable(Iterable<GeneticVariant> originalIterable) {
        return new VariantFilterIterable(new VariantFilterIterator(originalIterable.iterator(), this.qcChecker));
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public Map<String, Annotation> getVariantAnnotationsMap() {
        return this.originalGenotypeData.getVariantAnnotationsMap();
    }

    @Override
    public Map<String, SampleAnnotation> getSampleAnnotationsMap() {
        return this.originalGenotypeData.getSampleAnnotationsMap();
    }
}

