/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.genotype.variant.sampleProvider;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.molgenis.genotype.Alleles;
import org.molgenis.genotype.variant.GeneticVariant;
import org.molgenis.genotype.variant.sampleProvider.SampleVariantUniqueIdProvider;
import org.molgenis.genotype.variant.sampleProvider.SampleVariantsProvider;

public class SwappingSampleVariantsProvider
implements SampleVariantsProvider {
    private SampleVariantsProvider sampleVariantsProvider;
    private final int sampleVariantProviderUniqueId;

    public SwappingSampleVariantsProvider(SampleVariantsProvider sampleVariantsProvider) {
        this.sampleVariantsProvider = sampleVariantsProvider;
        this.sampleVariantProviderUniqueId = SampleVariantUniqueIdProvider.getNextUniqueId();
    }

    @Override
    public List<Alleles> getSampleVariants(GeneticVariant variant) {
        List<Alleles> sampleAlleles = this.sampleVariantsProvider.getSampleVariants(variant);
        ArrayList<Alleles> swapped = new ArrayList<Alleles>(sampleAlleles.size());
        for (Alleles alleles : sampleAlleles) {
            swapped.add(alleles.getComplement());
        }
        return Collections.unmodifiableList(swapped);
    }

    @Override
    public int cacheSize() {
        return 0;
    }

    @Override
    public List<Boolean> getSamplePhasing(GeneticVariant variant) {
        return this.sampleVariantsProvider.getSamplePhasing(variant);
    }

    @Override
    public int getSampleVariantProviderUniqueId() {
        return this.sampleVariantProviderUniqueId;
    }

    @Override
    public byte[] getSampleCalledDosage(GeneticVariant variant) {
        return this.sampleVariantsProvider.getSampleCalledDosage(variant);
    }

    @Override
    public float[] getSampleDosage(GeneticVariant variant) {
        return this.sampleVariantsProvider.getSampleDosage(variant);
    }
}

