/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.genotype.variant.sampleProvider;

import java.util.List;
import org.molgenis.genotype.Alleles;
import org.molgenis.genotype.util.Cache;
import org.molgenis.genotype.variant.GeneticVariant;
import org.molgenis.genotype.variant.sampleProvider.SampleVariantUniqueIdProvider;
import org.molgenis.genotype.variant.sampleProvider.SampleVariantsProvider;

public class CachedSampleVariantProvider
implements SampleVariantsProvider {
    private final SampleVariantsProvider sampleVariantProvider;
    private final Cache<GeneticVariant, List<Alleles>> cache;
    private final Cache<GeneticVariant, List<Boolean>> phasingCache;
    private final Cache<GeneticVariant, byte[]> calledDosageCache;
    private final Cache<GeneticVariant, float[]> dosageCache;
    private final int cacheSize;
    private final int sampleVariantProviderUniqueId;

    public CachedSampleVariantProvider(SampleVariantsProvider sampleVariantProvider, int cacheSize) {
        this.sampleVariantProvider = sampleVariantProvider;
        this.cache = new Cache(cacheSize);
        this.phasingCache = new Cache(cacheSize);
        this.calledDosageCache = new Cache(cacheSize);
        this.dosageCache = new Cache(cacheSize);
        this.cacheSize = cacheSize;
        this.sampleVariantProviderUniqueId = SampleVariantUniqueIdProvider.getNextUniqueId();
    }

    @Override
    public List<Alleles> getSampleVariants(GeneticVariant variant) {
        if (this.cache.containsKey(variant)) {
            return this.cache.get(variant);
        }
        List<Alleles> variantAlleles = this.sampleVariantProvider.getSampleVariants(variant);
        this.cache.put(variant, variantAlleles);
        return variantAlleles;
    }

    @Override
    public int cacheSize() {
        return this.cacheSize;
    }

    @Override
    public List<Boolean> getSamplePhasing(GeneticVariant variant) {
        if (this.phasingCache.containsKey(variant)) {
            return this.phasingCache.get(variant);
        }
        List<Boolean> phasing = this.sampleVariantProvider.getSamplePhasing(variant);
        this.phasingCache.put(variant, phasing);
        return phasing;
    }

    @Override
    public int getSampleVariantProviderUniqueId() {
        return this.sampleVariantProviderUniqueId;
    }

    @Override
    public byte[] getSampleCalledDosage(GeneticVariant variant) {
        if (this.calledDosageCache.containsKey(variant)) {
            return this.calledDosageCache.get(variant);
        }
        byte[] calledDosage = this.sampleVariantProvider.getSampleCalledDosage(variant);
        this.calledDosageCache.put(variant, calledDosage);
        return calledDosage;
    }

    @Override
    public float[] getSampleDosage(GeneticVariant variant) {
        if (this.dosageCache.containsKey(variant)) {
            return this.dosageCache.get(variant);
        }
        float[] dosage = this.sampleVariantProvider.getSampleDosage(variant);
        this.dosageCache.put(variant, dosage);
        return dosage;
    }
}

