/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.genotype.scripts;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.molgenis.genotype.Alleles;
import org.molgenis.genotype.Sample;
import org.molgenis.genotype.trityper.TriTyperGenotypeData;
import org.molgenis.genotype.variant.GeneticVariant;

public class Compare2TrityperDatasets {
    public static void main(String[] args) throws IOException {
        TriTyperGenotypeData dataset2;
        TriTyperGenotypeData dataset1;
        HashSet sharedSamples = new HashSet();
        HashMap<String, Integer> dataset1SampleMap = new HashMap<String, Integer>();
        HashMap<String, Integer> dataset2SampleMap = new HashMap<String, Integer>();
        try {
            dataset1 = new TriTyperGenotypeData(new File(args[0]));
        }
        catch (IOException ex) {
            System.err.println("Error reading dataset 1: " + args[0]);
            throw ex;
        }
        try {
            dataset2 = new TriTyperGenotypeData(new File(args[1]));
        }
        catch (IOException ex) {
            System.err.println("Error reading dataset 2: " + args[1]);
            throw ex;
        }
        int i = 0;
        for (Sample sample : dataset1.getSamples()) {
            dataset1SampleMap.put(sample.getId(), i);
            ++i;
        }
        i = 0;
        for (Sample sample : dataset2.getSamples()) {
            dataset2SampleMap.put(sample.getId(), i);
            ++i;
        }
        sharedSamples.addAll(dataset1SampleMap.keySet());
        sharedSamples.addAll(dataset2SampleMap.keySet());
        System.out.println("variantId\tcountIdentical\tcountMismatch");
        for (GeneticVariant dataset1Variant : dataset1) {
            GeneticVariant dataset2Variant = dataset2.getSnpVariantByPos(dataset1Variant.getSequenceName(), dataset1Variant.getStartPos());
            if (dataset2Variant == null) continue;
            List<Alleles> dataset1VariantAlleles = dataset1Variant.getSampleVariants();
            List<Alleles> dataset2VariantAlleles = dataset2Variant.getSampleVariants();
            int countIdentical = 0;
            int countMismatch = 0;
            for (String sharedSample : sharedSamples) {
                Alleles y;
                Alleles x = dataset1VariantAlleles.get((Integer)dataset1SampleMap.get(sharedSample));
                if (x.sameAlleles(y = dataset2VariantAlleles.get((Integer)dataset2SampleMap.get(sharedSample)))) {
                    ++countIdentical;
                    continue;
                }
                ++countMismatch;
            }
            System.out.println(dataset1Variant.getPrimaryVariantId() + "\t" + countIdentical + "\t" + countMismatch);
        }
    }
}

