/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.genotype.plink.drivers;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import org.molgenis.genotype.Alleles;
import org.molgenis.genotype.plink.PlinkFileParser;
import org.molgenis.genotype.plink.datatypes.PedEntry;
import org.molgenis.util.TextFileUtils;

public class PedFileDriver
implements PlinkFileParser,
Iterable<PedEntry> {
    private BufferedReader reader;
    private final File file;
    private final String separators;
    private long nrElements;

    public PedFileDriver(File pedFile) {
        this(pedFile, " \t");
    }

    public PedFileDriver(File pedFile, char separator) {
        this(pedFile, String.valueOf(separator));
    }

    public PedFileDriver(File pedFile, String separators) {
        if (pedFile == null) {
            throw new IllegalArgumentException("file is null");
        }
        this.file = pedFile;
        this.separators = separators;
        this.nrElements = -1L;
    }

    public List<PedEntry> getAllEntries() throws IOException {
        String line;
        this.reset();
        ArrayList<PedEntry> entryList = new ArrayList<PedEntry>();
        while ((line = this.reader.readLine()) != null) {
            entryList.add(this.parseEntry(line));
        }
        return entryList;
    }

    @Override
    public Iterator<PedEntry> iterator() {
        try {
            this.reset();
            return new PedFileIterator();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public List<PedEntry> getEntries(long from, long to) throws IOException {
        String line;
        this.reset();
        ArrayList<PedEntry> entryList = new ArrayList<PedEntry>();
        int i = 0;
        while ((line = this.reader.readLine()) != null && (long)i < to) {
            if ((long)i >= from) {
                entryList.add(this.parseEntry(line));
            }
            ++i;
        }
        return entryList;
    }

    private PedEntry parseEntry(String line) throws IOException {
        final StringTokenizer strTokenizer = new StringTokenizer(line, this.separators);
        try {
            String family = new String(strTokenizer.nextToken());
            String individual = new String(strTokenizer.nextToken());
            String father = new String(strTokenizer.nextToken());
            String mother = new String(strTokenizer.nextToken());
            byte sex = Byte.parseByte(strTokenizer.nextToken());
            double phenotype = Double.parseDouble(strTokenizer.nextToken());
            return new PedEntry(family, individual, father, mother, sex, phenotype, new Iterator<Alleles>(){

                @Override
                public boolean hasNext() {
                    return strTokenizer.hasMoreTokens();
                }

                @Override
                public Alleles next() {
                    char allele1 = strTokenizer.nextToken().charAt(0);
                    char allele2 = strTokenizer.nextToken().charAt(0);
                    return Alleles.createBasedOnChars(allele1, allele2);
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            });
        }
        catch (NoSuchElementException e) {
            throw new IOException("error in line: " + line, e);
        }
        catch (IndexOutOfBoundsException e) {
            throw new IOException("error in line: " + line, e);
        }
        catch (NumberFormatException e) {
            throw new IOException("error in line: " + line, e);
        }
    }

    public long getNrOfElements() throws IOException {
        if (this.nrElements == -1L) {
            this.nrElements = TextFileUtils.getNumberOfNonEmptyLines((File)this.file, (Charset)FILE_ENCODING);
        }
        return this.nrElements;
    }

    @Override
    public void close() throws IOException {
        if (this.reader != null) {
            this.reader.close();
        }
    }

    public void reset() throws IOException {
        if (this.reader != null) {
            this.close();
        }
        this.reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.file), FILE_ENCODING));
    }

    private class PedFileIterator
    implements Iterator<PedEntry> {
        private String line;

        public PedFileIterator() {
            try {
                this.line = PedFileDriver.this.reader.readLine();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public boolean hasNext() {
            return this.line != null;
        }

        @Override
        public PedEntry next() {
            PedEntry entry;
            try {
                entry = PedFileDriver.this.parseEntry(this.line);
                this.line = PedFileDriver.this.reader.readLine();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            return entry;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

