/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.genotype.plink;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;
import org.molgenis.genotype.AbstractRandomAccessGenotypeData;
import org.molgenis.genotype.Allele;
import org.molgenis.genotype.Alleles;
import org.molgenis.genotype.Sample;
import org.molgenis.genotype.Sequence;
import org.molgenis.genotype.SimpleSequence;
import org.molgenis.genotype.annotation.Annotation;
import org.molgenis.genotype.annotation.SampleAnnotation;
import org.molgenis.genotype.annotation.SexAnnotation;
import org.molgenis.genotype.plink.PlinkSampleAnnotations;
import org.molgenis.genotype.plink.datatypes.MapEntry;
import org.molgenis.genotype.plink.datatypes.PedEntry;
import org.molgenis.genotype.plink.drivers.PedFileDriver;
import org.molgenis.genotype.plink.readers.MapFileReader;
import org.molgenis.genotype.util.Cache;
import org.molgenis.genotype.util.CalledDosageConvertor;
import org.molgenis.genotype.util.GeneticVariantTreeSet;
import org.molgenis.genotype.variant.GeneticVariant;
import org.molgenis.genotype.variant.ReadOnlyGeneticVariant;
import org.molgenis.genotype.variant.sampleProvider.SampleVariantUniqueIdProvider;
import org.molgenis.genotype.variant.sampleProvider.SampleVariantsProvider;

public class PedMapGenotypeData
extends AbstractRandomAccessGenotypeData
implements SampleVariantsProvider {
    private static final Logger LOG = Logger.getLogger(PedMapGenotypeData.class);
    private final int sampleVariantProviderUniqueId;
    private final File pedFile;
    private Map<Integer, List<Alleles>> sampleAllelesBySnpIndex = new HashMap<Integer, List<Alleles>>();
    private GeneticVariantTreeSet<GeneticVariant> snps = new GeneticVariantTreeSet();
    private Map<String, Integer> snpIndexById = new HashMap<String, Integer>(1000);
    private Map<String, SampleAnnotation> sampleAnnotations;
    private final Cache<GeneticVariant, byte[]> calledDosageCache;
    private final Cache<GeneticVariant, float[]> dosageCache;
    private ArrayList<Sample> samples = new ArrayList();
    private HashSet<String> seqNames = new HashSet();

    public PedMapGenotypeData(String basePath) throws FileNotFoundException, IOException {
        this(new File(basePath + ".ped"), new File(basePath + ".map"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PedMapGenotypeData(File pedFile, File mapFile) throws FileNotFoundException, IOException {
        if (pedFile == null) {
            throw new IllegalArgumentException("PedFile is null");
        }
        if (mapFile == null) {
            throw new IllegalArgumentException("MapFile is null");
        }
        if (!mapFile.isFile()) {
            throw new FileNotFoundException("MAP index file not found at " + mapFile.getAbsolutePath());
        }
        if (!mapFile.canRead()) {
            throw new IOException("MAP index file not found at " + mapFile.getAbsolutePath());
        }
        if (!pedFile.isFile()) {
            throw new FileNotFoundException("PED file not found at " + pedFile.getAbsolutePath());
        }
        if (!pedFile.canRead()) {
            throw new IOException("PED file not found at " + pedFile.getAbsolutePath());
        }
        this.pedFile = pedFile;
        MapFileReader mapFileReader = null;
        PedFileDriver pedFileDriver = null;
        try {
            pedFileDriver = new PedFileDriver(pedFile);
            this.loadSampleBialleles(pedFileDriver);
            mapFileReader = new MapFileReader(new FileInputStream(mapFile));
            this.loadSnps(mapFileReader);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(pedFileDriver);
            IOUtils.closeQuietly(mapFileReader);
            throw throwable;
        }
        IOUtils.closeQuietly((Closeable)pedFileDriver);
        IOUtils.closeQuietly((Closeable)mapFileReader);
        this.sampleVariantProviderUniqueId = SampleVariantUniqueIdProvider.getNextUniqueId();
        this.sampleAnnotations = PlinkSampleAnnotations.getSampleAnnotations();
        this.calledDosageCache = new Cache(100);
        this.dosageCache = new Cache(100);
    }

    private void loadSampleBialleles(PedFileDriver pedFileDriver) {
        int count = 0;
        for (PedEntry entry : pedFileDriver) {
            LinkedHashMap<String, Object> annotationValues = new LinkedHashMap<String, Object>();
            annotationValues.put("fatherId", entry.getFather());
            annotationValues.put("motherId", entry.getMother());
            annotationValues.put("sex_generic", (Object)SexAnnotation.getSexAnnotationForPlink(entry.getSex()));
            annotationValues.put("phenotype", entry.getPhenotype());
            this.samples.add(new Sample(entry.getIndividual(), entry.getFamily(), annotationValues));
            int index = 0;
            for (Alleles biallele : entry) {
                List<Alleles> biallelesForSnp = this.sampleAllelesBySnpIndex.get(index);
                if (biallelesForSnp == null) {
                    biallelesForSnp = new ArrayList<Alleles>();
                    this.sampleAllelesBySnpIndex.put(index, biallelesForSnp);
                }
                biallelesForSnp.add(biallele);
                ++index;
            }
            if (++count % 100 != 0) continue;
            LOG.info((Object)("Loaded [" + count + "] samples"));
        }
        LOG.info((Object)("Total [" + count + "] samples"));
    }

    private void loadSnps(MapFileReader reader) {
        int index = 0;
        for (MapEntry entry : reader) {
            String id = entry.getSNP();
            String sequenceName = entry.getChromosome();
            this.seqNames.add(sequenceName);
            int startPos = (int)entry.getBpPos();
            List<Alleles> sampleAlleles = this.sampleAllelesBySnpIndex.get(index);
            ArrayList<String> alleles = new ArrayList<String>(2);
            for (Alleles biallele : sampleAlleles) {
                String allele2;
                String allele1;
                String string = allele1 = biallele.get(0) == Allele.ZERO ? null : biallele.get(0).toString();
                if (allele1 != null && !alleles.contains(allele1)) {
                    alleles.add(allele1);
                }
                if ((allele2 = biallele.get(1) == Allele.ZERO ? null : biallele.get(1).toString()) == null || alleles.contains(allele2)) continue;
                alleles.add(allele2);
            }
            GeneticVariant snp = ReadOnlyGeneticVariant.createVariant(id, startPos, sequenceName, (SampleVariantsProvider)this, alleles);
            this.snps.add(snp);
            this.snpIndexById.put(snp.getPrimaryVariantId(), index);
            if (++index % 100000 != 0) continue;
            LOG.info((Object)("Loaded [" + index + "] snps"));
        }
        LOG.info((Object)("Total [" + index + "] snps"));
    }

    public List<Sequence> getSequences() {
        List<String> seqNames = this.getSeqNames();
        ArrayList<Sequence> sequences = new ArrayList<Sequence>(seqNames.size());
        for (String seqName : seqNames) {
            sequences.add(new SimpleSequence(seqName, null, this));
        }
        return sequences;
    }

    @Override
    public List<Sample> getSamples() {
        return this.samples;
    }

    @Override
    public List<Alleles> getSampleVariants(GeneticVariant variant) {
        if (variant.getPrimaryVariantId() == null) {
            throw new IllegalArgumentException("Not a snp, missing primaryVariantId");
        }
        Integer index = this.snpIndexById.get(variant.getPrimaryVariantId());
        if (index == null) {
            throw new IllegalArgumentException("Unknown primaryVariantId [" + variant.getPrimaryVariantId() + "]");
        }
        List<Alleles> bialleles = this.sampleAllelesBySnpIndex.get(index);
        return Collections.unmodifiableList(bialleles);
    }

    @Override
    public Map<String, Annotation> getVariantAnnotationsMap() {
        return Collections.emptyMap();
    }

    @Override
    public List<String> getSeqNames() {
        return new ArrayList<String>(this.seqNames);
    }

    public List<GeneticVariant> getVariantsByPos(String seqName, int startPos) {
        return new ArrayList<GeneticVariant>(this.snps.getSequencePosVariants(seqName, startPos));
    }

    @Override
    public Iterator<GeneticVariant> iterator() {
        return this.snps.iterator();
    }

    @Override
    public Iterable<GeneticVariant> getSequenceGeneticVariants(String seqName) {
        return this.snps.getSequenceVariants(seqName);
    }

    @Override
    public int cacheSize() {
        return 0;
    }

    @Override
    public List<Boolean> getSamplePhasing(GeneticVariant variant) {
        List<Boolean> phasing = Collections.nCopies(this.getSampleVariants(variant).size(), false);
        return phasing;
    }

    @Override
    public int getSampleVariantProviderUniqueId() {
        return this.sampleVariantProviderUniqueId;
    }

    @Override
    public Map<String, SampleAnnotation> getSampleAnnotationsMap() {
        return this.sampleAnnotations;
    }

    @Override
    public Iterable<GeneticVariant> getVariantsByRange(String seqName, int rangeStart, int rangeEnd) {
        return this.snps.getSequenceRangeVariants(seqName, rangeStart, rangeEnd);
    }

    @Override
    public byte[] getSampleCalledDosage(GeneticVariant variant) {
        if (this.calledDosageCache.containsKey(variant)) {
            return this.calledDosageCache.get(variant);
        }
        byte[] calledDosage = CalledDosageConvertor.convertCalledAllelesToCalledDosage(this.getSampleVariants(variant), variant.getVariantAlleles(), variant.getRefAllele());
        this.calledDosageCache.put(variant, calledDosage);
        return calledDosage;
    }

    @Override
    public float[] getSampleDosage(GeneticVariant variant) {
        if (this.dosageCache.containsKey(variant)) {
            return this.dosageCache.get(variant);
        }
        float[] dosage = CalledDosageConvertor.convertCalledAllelesToDosage(this.getSampleVariants(variant), variant.getVariantAlleles(), variant.getRefAllele());
        this.dosageCache.put(variant, dosage);
        return dosage;
    }

    @Override
    public void close() throws IOException {
    }
}

