/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.genotype.multipart;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.molgenis.genotype.AbstractRandomAccessGenotypeData;
import org.molgenis.genotype.RandomAccessGenotypeData;
import org.molgenis.genotype.Sample;
import org.molgenis.genotype.Sequence;
import org.molgenis.genotype.annotation.Annotation;
import org.molgenis.genotype.annotation.SampleAnnotation;
import org.molgenis.genotype.multipart.IncompatibleMultiPartGenotypeDataException;
import org.molgenis.genotype.multipart.MultiPartSequencesIterable;
import org.molgenis.genotype.multipart.MultiPartVariantsIterable;
import org.molgenis.genotype.variant.GeneticVariant;
import org.molgenis.genotype.vcf.VcfGenotypeData;

public class MultiPartGenotypeData
extends AbstractRandomAccessGenotypeData {
    private List<Sample> samples = null;
    private static final Pattern VCF_PATTERN = Pattern.compile("vcf.gz$", 2);
    private final Map<String, Annotation> variantAnnotationsMap;
    private final Map<String, SampleAnnotation> sampleAnnotationsMap;
    private LinkedHashMap<String, RandomAccessGenotypeData> genotypeDatasets = new LinkedHashMap();
    private Set<RandomAccessGenotypeData> genotypeDataCollection;

    public MultiPartGenotypeData(Collection<RandomAccessGenotypeData> genotypeDataCollection) throws IncompatibleMultiPartGenotypeDataException {
        this(new HashSet<RandomAccessGenotypeData>(genotypeDataCollection));
    }

    public MultiPartGenotypeData(HashSet<RandomAccessGenotypeData> genotypeDataCollection) throws IncompatibleMultiPartGenotypeDataException {
        this.variantAnnotationsMap = new HashMap<String, Annotation>();
        this.sampleAnnotationsMap = new HashMap<String, SampleAnnotation>();
        for (RandomAccessGenotypeData genotypeData : genotypeDataCollection) {
            if (this.samples != null) {
                if (!((Object)genotypeData.getSamples()).equals(this.samples)) {
                    throw new IncompatibleMultiPartGenotypeDataException("Incompatible multi part genotype data. All files should contain identical samples in same order.");
                }
            } else {
                this.samples = genotypeData.getSamples();
            }
            for (String seqName : genotypeData.getSeqNames()) {
                if (this.genotypeDatasets.containsKey(seqName)) {
                    throw new IncompatibleMultiPartGenotypeDataException("Incompatible multi part genotype data. A seq/chr can not be present in multiple files.");
                }
                this.genotypeDatasets.put(seqName, genotypeData);
            }
            this.variantAnnotationsMap.putAll(genotypeData.getVariantAnnotationsMap());
            this.sampleAnnotationsMap.putAll(genotypeData.getSampleAnnotationsMap());
        }
        this.genotypeDataCollection = genotypeDataCollection;
    }

    public static MultiPartGenotypeData createFromVcfFolder(File vcfFolder, int cacheSize) throws IOException, IncompatibleMultiPartGenotypeDataException {
        HashSet<RandomAccessGenotypeData> genotypeDataSets = new HashSet<RandomAccessGenotypeData>();
        if (!vcfFolder.isDirectory()) {
            throw new IOException("This is not a directory: " + vcfFolder.getAbsolutePath());
        }
        for (File file : vcfFolder.listFiles()) {
            Matcher matcher;
            if (file.isDirectory() || !(matcher = VCF_PATTERN.matcher(file.getName())).matches()) continue;
            genotypeDataSets.add(new VcfGenotypeData(file, cacheSize));
        }
        return new MultiPartGenotypeData((Collection<RandomAccessGenotypeData>)genotypeDataSets);
    }

    @Override
    public List<String> getSeqNames() {
        return new ArrayList<String>(this.genotypeDatasets.keySet());
    }

    @Override
    public Iterable<Sequence> getSequences() {
        return new MultiPartSequencesIterable(this.genotypeDatasets.values());
    }

    @Override
    public Sequence getSequenceByName(String name) {
        if (this.genotypeDatasets.containsKey(name)) {
            return this.genotypeDatasets.get(name).getSequenceByName(name);
        }
        return null;
    }

    @Override
    public List<Annotation> getVariantAnnotations() {
        throw new UnsupportedOperationException("Not yet implemented for multipart genotype data. Feel free to contact the developers");
    }

    @Override
    public Annotation getVariantAnnotation(String annotationId) {
        throw new UnsupportedOperationException("Not yet implemented for multipart genotype data. Feel free to contact the developers");
    }

    @Override
    public Iterable<GeneticVariant> getVariantsByPos(String seqName, int startPos) {
        if (this.genotypeDatasets.containsKey(seqName)) {
            return this.genotypeDatasets.get(seqName).getVariantsByPos(seqName, startPos);
        }
        return Collections.emptyList();
    }

    @Override
    public GeneticVariant getSnpVariantByPos(String seqName, int startPos) {
        if (this.genotypeDatasets.containsKey(seqName)) {
            return this.genotypeDatasets.get(seqName).getSnpVariantByPos(seqName, startPos);
        }
        return null;
    }

    @Override
    public List<Sample> getSamples() {
        return Collections.unmodifiableList(this.samples);
    }

    @Override
    public Iterator<GeneticVariant> iterator() {
        return new MultiPartVariantsIterable(this.genotypeDataCollection).iterator();
    }

    @Override
    public Iterable<GeneticVariant> getSequenceGeneticVariants(String seqName) {
        if (this.genotypeDatasets.containsKey(seqName)) {
            return this.genotypeDatasets.get(seqName).getSequenceGeneticVariants(seqName);
        }
        return Collections.emptyList();
    }

    @Override
    public List<SampleAnnotation> getSampleAnnotations() {
        throw new UnsupportedOperationException("Not yet implemented for multipart genotype data. Feel free to contact the developers");
    }

    @Override
    public Annotation getSampleAnnotation(String annotationId) {
        throw new UnsupportedOperationException("Not yet implemented for multipart genotype data. Feel free to contact the developers");
    }

    @Override
    public Iterable<GeneticVariant> getVariantsByRange(String seqName, int rangeStart, int rangeEnd) {
        if (this.genotypeDatasets.containsKey(seqName)) {
            return this.genotypeDatasets.get(seqName).getVariantsByRange(seqName, rangeStart, rangeEnd);
        }
        return null;
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public Map<String, Annotation> getVariantAnnotationsMap() {
        return this.variantAnnotationsMap;
    }

    @Override
    public Map<String, SampleAnnotation> getSampleAnnotationsMap() {
        return this.getSampleAnnotationsMap();
    }
}

