/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.genotype.modifiable;

import java.util.List;
import java.util.Map;
import org.molgenis.genotype.Allele;
import org.molgenis.genotype.Alleles;
import org.molgenis.genotype.GenotypeDataException;
import org.molgenis.genotype.modifiable.ModifiableGenotypeData;
import org.molgenis.genotype.util.Ld;
import org.molgenis.genotype.util.LdCalculator;
import org.molgenis.genotype.util.LdCalculatorException;
import org.molgenis.genotype.util.MafCalculator;
import org.molgenis.genotype.util.MafResult;
import org.molgenis.genotype.variant.AbstractGeneticVariant;
import org.molgenis.genotype.variant.GeneticVariant;
import org.molgenis.genotype.variant.id.GeneticVariantId;
import org.molgenis.genotype.variant.sampleProvider.SampleVariantsProvider;

public class ModifiableGeneticVariant
extends AbstractGeneticVariant {
    private final GeneticVariant originalVariant;
    private final ModifiableGenotypeData modifiableGenotypeData;

    public ModifiableGeneticVariant(GeneticVariant originalVariant, ModifiableGenotypeData modifiableGenotypeData) {
        this.originalVariant = originalVariant;
        this.modifiableGenotypeData = modifiableGenotypeData;
    }

    @Override
    public String getPrimaryVariantId() {
        return this.getVariantId().getPrimairyId();
    }

    @Override
    public List<String> getAlternativeVariantIds() {
        return this.getVariantId().getAlternativeIds();
    }

    @Override
    public List<String> getAllIds() {
        return this.getVariantId().getVariantIds();
    }

    @Override
    public GeneticVariantId getVariantId() {
        GeneticVariantId variantId = this.modifiableGenotypeData.getUpdatedId(this);
        if (variantId != null) {
            return variantId;
        }
        return this.originalVariant.getVariantId();
    }

    @Override
    public int getStartPos() {
        return this.originalVariant.getStartPos();
    }

    @Override
    public String getSequenceName() {
        return this.originalVariant.getSequenceName();
    }

    @Override
    public Alleles getVariantAlleles() {
        Alleles alleles = this.modifiableGenotypeData.getUpdatedAlleles(this);
        if (alleles != null) {
            return alleles;
        }
        return this.originalVariant.getVariantAlleles();
    }

    @Override
    public int getAlleleCount() {
        return this.getVariantAlleles().getAlleleCount();
    }

    @Override
    public Allele getRefAllele() {
        Allele refAllele = this.modifiableGenotypeData.getUpdatedRef(this);
        if (refAllele != null) {
            return refAllele;
        }
        return this.originalVariant.getRefAllele();
    }

    @Override
    public List<Alleles> getSampleVariants() {
        return this.getSampleVariantsProvider().getSampleVariants(this.originalVariant);
    }

    @Override
    public List<Boolean> getSamplePhasing() {
        return this.getSampleVariantsProvider().getSamplePhasing(this.originalVariant);
    }

    @Override
    public Map<String, ?> getAnnotationValues() {
        return this.originalVariant.getAnnotationValues();
    }

    @Override
    public double getMinorAlleleFrequency() {
        try {
            MafResult mafResult = MafCalculator.calculateMaf(this.getVariantAlleles(), this.getRefAllele(), this.getSampleVariants());
            return mafResult.getFreq();
        }
        catch (NullPointerException e) {
            throw new GenotypeDataException("NullPointerException in maf caculation. " + this.getVariantAlleles() + " ref: " + this.getRefAllele(), e);
        }
    }

    @Override
    public Allele getMinorAllele() {
        try {
            MafResult mafResult = MafCalculator.calculateMaf(this.getVariantAlleles(), this.getRefAllele(), this.getSampleVariants());
            return mafResult.getMinorAllele();
        }
        catch (NullPointerException e) {
            throw new GenotypeDataException("NullPointerException in maf caculation. " + this.getVariantAlleles() + " ref: " + this.getRefAllele(), e);
        }
    }

    @Override
    public boolean isSnp() {
        return this.getVariantAlleles().isSnp();
    }

    @Override
    public boolean isAtOrGcSnp() {
        return this.getVariantAlleles().isAtOrGcSnp();
    }

    @Override
    public Ld calculateLd(GeneticVariant other) throws LdCalculatorException {
        return LdCalculator.calculateLd(this, other);
    }

    @Override
    public boolean isBiallelic() {
        return this.getVariantAlleles().getAlleleCount() == 2;
    }

    @Override
    public float[] getSampleDosages() {
        Allele refShouldBeUsed;
        float[] dosageByProvider = this.getSampleVariantsProvider().getSampleDosage(this.originalVariant);
        Allele refUsedForOriginalDosage = this.originalVariant.getRefAllele() == null ? this.originalVariant.getVariantAlleles().get(0) : this.originalVariant.getRefAllele();
        Allele allele = refShouldBeUsed = this.getRefAllele() == null ? this.getVariantAlleles().get(0) : this.getRefAllele();
        if (refUsedForOriginalDosage == refShouldBeUsed) {
            return dosageByProvider;
        }
        if (refUsedForOriginalDosage == refShouldBeUsed.getComplement()) {
            return dosageByProvider;
        }
        float[] newDosage = new float[dosageByProvider.length];
        for (int i = 0; i < dosageByProvider.length; ++i) {
            newDosage[i] = dosageByProvider[i] * -1.0f + 2.0f;
        }
        return newDosage;
    }

    @Override
    public byte[] getSampleCalledDosages() {
        Allele refShouldBeUsed;
        byte[] dosageByProvider = this.getSampleVariantsProvider().getSampleCalledDosage(this.originalVariant);
        Allele refUsedForOriginalDosage = this.originalVariant.getRefAllele() == null ? this.originalVariant.getVariantAlleles().get(0) : this.originalVariant.getRefAllele();
        Allele allele = refShouldBeUsed = this.getRefAllele() == null ? this.getVariantAlleles().get(0) : this.getRefAllele();
        if (refUsedForOriginalDosage == refShouldBeUsed) {
            return dosageByProvider;
        }
        if (refUsedForOriginalDosage == refShouldBeUsed.getComplement()) {
            return dosageByProvider;
        }
        byte[] newDosage = new byte[dosageByProvider.length];
        for (int i = 0; i < dosageByProvider.length; ++i) {
            newDosage[i] = (byte)(dosageByProvider[i] * -1 + 2);
        }
        return newDosage;
    }

    @Override
    public SampleVariantsProvider getSampleVariantsProvider() {
        SampleVariantsProvider sampleVariantProvider = this.modifiableGenotypeData.getUpdatedSampleVariantProvider(this);
        if (sampleVariantProvider != null) {
            return sampleVariantProvider;
        }
        return this.originalVariant.getSampleVariantsProvider();
    }

    protected GeneticVariant getOriginalVariant() {
        return this.originalVariant;
    }

    public void updateRefAllele(Allele newRefAllele) {
        this.modifiableGenotypeData.updateRefAllele(this, newRefAllele);
    }

    public void updateRefAllele(String newRefAllele) {
        this.updateRefAllele(Allele.create(newRefAllele));
    }

    public void updateRefAllele(char newRefAllele) {
        this.updateRefAllele(Allele.create(newRefAllele));
    }

    public void updatePrimaryId(String newPrimaryId) {
        this.modifiableGenotypeData.updateVariantPrimaryId(this, newPrimaryId);
    }

    public void updateId(GeneticVariantId newVariantId) {
        this.modifiableGenotypeData.updateVariantId(this, newVariantId);
    }

    public void swap() {
        this.modifiableGenotypeData.swapGeneticVariant(this);
    }

    public void exclude() {
        this.modifiableGenotypeData.excludeVariant(this);
    }
}

