/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.genotype.impute2;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;
import org.molgenis.genotype.Allele;
import org.molgenis.genotype.Alleles;
import org.molgenis.genotype.GenotypeData;
import org.molgenis.genotype.GenotypeWriter;
import org.molgenis.genotype.Sample;
import org.molgenis.genotype.annotation.SampleAnnotation;
import org.molgenis.genotype.annotation.SexAnnotation;
import org.molgenis.genotype.util.Utils;
import org.molgenis.genotype.variant.GeneticVariant;

public class Impute2GenotypeWriter
implements GenotypeWriter {
    public static final Charset FILE_ENCODING = Charset.forName("UTF-8");
    public static final String LINE_ENDING = "\n";
    private static final char SEPARATOR = ' ';
    private static final char UNPHASED_INDICATOR = '*';
    private static final char MISSING_INDICATOR = '?';
    private static final Logger LOG = Logger.getLogger(Impute2GenotypeWriter.class);
    private GenotypeData genotypeData;

    public Impute2GenotypeWriter(GenotypeData genotypeData) {
        this.genotypeData = genotypeData;
    }

    @Override
    public void write(String basePath) throws IOException {
        this.write(new File(basePath + ".haps"), new File(basePath + ".sample"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(File hapsFile, File sampleFile) throws IOException {
        LOG.info((Object)("Writing haps file [" + hapsFile.getAbsolutePath() + "] and sample file [" + sampleFile.getAbsolutePath() + "]"));
        Utils.createEmptyFile(hapsFile, "haps");
        Utils.createEmptyFile(sampleFile, "sample");
        BufferedWriter hapsFileWriter = null;
        BufferedWriter sampleFileWriter = null;
        try {
            hapsFileWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(hapsFile), FILE_ENCODING));
            sampleFileWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(sampleFile), FILE_ENCODING));
            this.write(hapsFileWriter, sampleFileWriter);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(hapsFileWriter);
            IOUtils.closeQuietly(sampleFileWriter);
            throw throwable;
        }
        IOUtils.closeQuietly((Writer)hapsFileWriter);
        IOUtils.closeQuietly((Writer)sampleFileWriter);
    }

    public void write(Writer hapsFileWriter, Writer sampleFileWriter) throws IOException {
        this.writeHapsFile(hapsFileWriter);
        this.writeSampleFile(sampleFileWriter);
    }

    private void writeSampleFile(Writer sampleWriter) throws IOException {
        StringBuilder sb = new StringBuilder();
        sb.append("ID_1");
        sb.append(' ');
        sb.append("ID_2");
        sb.append(' ');
        sb.append("missing");
        ArrayList<String> colNames = new ArrayList<String>();
        ArrayList<String> dataTypes = new ArrayList<String>();
        block10: for (SampleAnnotation annotation : this.genotypeData.getSampleAnnotations()) {
            if (annotation.getId().equals("sampleMissingRateDouble")) continue;
            if (annotation.getSampleAnnotationType() == SampleAnnotation.SampleAnnotationType.COVARIATE) {
                switch (annotation.getType()) {
                    case INTEGER: {
                        colNames.add(annotation.getId());
                        dataTypes.add("D");
                        continue block10;
                    }
                    case STRING: {
                        colNames.add(annotation.getId());
                        dataTypes.add("D");
                        continue block10;
                    }
                    case SEX: {
                        colNames.add(annotation.getId());
                        dataTypes.add("D");
                        continue block10;
                    }
                    case FLOAT: {
                        colNames.add(annotation.getId());
                        dataTypes.add("C");
                        continue block10;
                    }
                }
                LOG.warn((Object)("Unsupported covariate datatype [" + (Object)((Object)annotation.getType()) + "]"));
                continue;
            }
            if (annotation.getSampleAnnotationType() == SampleAnnotation.SampleAnnotationType.PHENOTYPE) {
                switch (annotation.getType()) {
                    case BOOLEAN: {
                        colNames.add(annotation.getId());
                        dataTypes.add("B");
                        continue block10;
                    }
                    case FLOAT: {
                        colNames.add(annotation.getId());
                        dataTypes.add("P");
                        continue block10;
                    }
                }
                LOG.warn((Object)("Unsupported phenotype datatype [" + (Object)((Object)annotation.getType()) + "]"));
                continue;
            }
            LOG.warn((Object)"'OTHER' sample annotation type not supported by impute2");
        }
        for (String colName : colNames) {
            sb.append(' ');
            sb.append(colName);
        }
        sb.append(LINE_ENDING);
        sb.append("0");
        sb.append(' ');
        sb.append("0");
        sb.append(' ');
        sb.append("0");
        for (String dataType : dataTypes) {
            sb.append(' ');
            sb.append(dataType);
        }
        sb.append(LINE_ENDING);
        sampleWriter.write(sb.toString());
        for (Sample sample : this.genotypeData.getSamples()) {
            sb = new StringBuilder();
            sb.append(sample.getFamilyId() == null ? "NA" : sample.getFamilyId());
            sb.append(' ');
            sb.append(sample.getId() == null ? "NA" : sample.getId());
            sb.append(' ');
            sb.append(this.getValue("sampleMissingRateDouble", sample, "NA"));
            for (String colName : colNames) {
                sb.append(' ');
                sb.append(this.getValue(colName, sample, "NA"));
            }
            sb.append(LINE_ENDING);
            sampleWriter.write(sb.toString());
        }
    }

    private String getValue(String colName, Sample sample, String nullValue) {
        Object value = sample.getAnnotationValues().get(colName);
        if (value == null) {
            return nullValue;
        }
        if (value instanceof Boolean) {
            return value.equals(true) ? "1" : "0";
        }
        if (value instanceof Double) {
            if (Double.isNaN((Double)value)) {
                return nullValue;
            }
            String result = value.toString();
            if (result.equals("0.0")) {
                result = "0";
            }
            return result;
        }
        if (value instanceof Float) {
            if (Float.isNaN(((Float)value).floatValue())) {
                return nullValue;
            }
            String result = value.toString();
            if (result.equals("0.0")) {
                result = "0";
            }
            return result;
        }
        if (value instanceof SexAnnotation) {
            return Byte.toString(((SexAnnotation)((Object)value)).getPlinkSex());
        }
        return value.toString();
    }

    private void writeHapsFile(Writer hapsFileWriter) throws IOException {
        for (GeneticVariant variant : this.genotypeData) {
            if (variant.getAlleleCount() > 2) {
                LOG.warn((Object)("Skipping variant: " + variant.getPrimaryVariantId() + " at " + variant.getSequenceName() + ":" + variant.getStartPos() + " with more than 22 alleles: " + variant.getVariantAlleles()));
            }
            Allele allele0 = variant.getVariantAlleles().get(0);
            Allele allele1 = variant.getAlleleCount() == 1 ? Allele.ZERO : variant.getVariantAlleles().get(1);
            StringBuilder sb = new StringBuilder();
            sb.append(variant.getSequenceName());
            sb.append(' ');
            sb.append(variant.getPrimaryVariantId());
            sb.append(' ');
            sb.append(variant.getStartPos());
            sb.append(' ');
            sb.append(allele0);
            sb.append(' ');
            sb.append(allele1);
            List<Alleles> sampleAlleles = variant.getSampleVariants();
            List<Boolean> phasing = variant.getSamplePhasing();
            if (sampleAlleles != null && !sampleAlleles.isEmpty()) {
                for (int i = 0; i < sampleAlleles.size(); ++i) {
                    sb.append(' ');
                    Alleles alleles = sampleAlleles.get(i);
                    if (alleles == null || alleles.getAllelesAsString().isEmpty() || alleles.get(0) == Allele.ZERO || alleles.get(1) == Allele.ZERO) {
                        sb.append('?');
                        sb.append(' ');
                        sb.append('?');
                        continue;
                    }
                    if (alleles.get(0).equals(allele0)) {
                        sb.append("0");
                    } else if (alleles.get(0).equals(allele1)) {
                        sb.append("1");
                    } else {
                        throw new RuntimeException("SampleAllele [" + alleles.get(0) + "] for SNP [" + variant.getPrimaryVariantId() + "] does not match one of the variant alleles");
                    }
                    if (!phasing.get(i).booleanValue()) {
                        sb.append('*');
                    }
                    sb.append(' ');
                    if (alleles.get(1).equals(allele0)) {
                        sb.append("0");
                    } else if (alleles.get(1).equals(allele1)) {
                        sb.append("1");
                    } else {
                        throw new RuntimeException("SampleAllele [" + alleles.get(1) + "] for SNP [" + variant.getPrimaryVariantId() + "] does not match one of the variant alleles");
                    }
                    if (phasing.get(i).booleanValue()) continue;
                    sb.append('*');
                }
            }
            sb.append(LINE_ENDING);
            hapsFileWriter.write(sb.toString());
        }
    }
}

