/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.genotype.impute2;

import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;
import org.molgenis.genotype.AbstractRandomAccessGenotypeData;
import org.molgenis.genotype.Allele;
import org.molgenis.genotype.Alleles;
import org.molgenis.genotype.GenotypeDataException;
import org.molgenis.genotype.Sample;
import org.molgenis.genotype.Sequence;
import org.molgenis.genotype.SimpleSequence;
import org.molgenis.genotype.annotation.Annotation;
import org.molgenis.genotype.annotation.SampleAnnotation;
import org.molgenis.genotype.util.CalledDosageConvertor;
import org.molgenis.genotype.util.GeneticVariantTreeSet;
import org.molgenis.genotype.util.Utils;
import org.molgenis.genotype.variant.GeneticVariant;
import org.molgenis.genotype.variant.ReadOnlyGeneticVariant;
import org.molgenis.genotype.variant.sampleProvider.CachedSampleVariantProvider;
import org.molgenis.genotype.variant.sampleProvider.SampleVariantUniqueIdProvider;
import org.molgenis.genotype.variant.sampleProvider.SampleVariantsProvider;
import org.molgenis.io.csv.CsvReader;
import org.molgenis.util.tuple.Tuple;

public class Impute2GenotypeData
extends AbstractRandomAccessGenotypeData
implements SampleVariantsProvider {
    private final RandomAccessFile hapsFileReader;
    private Map<String, SampleAnnotation> sampleAnnotations = new LinkedHashMap<String, SampleAnnotation>();
    private final int sampleVariantProviderUniqueId;
    private final SampleVariantsProvider sampleVariantProvider;
    private final GeneticVariantTreeSet<GeneticVariant> variants;
    private final LinkedHashMap<GeneticVariant, Long> variantSampleAllelesIndex;
    private final List<Sample> samples;
    private final HashSet<String> sequenceNames;
    private final int byteToReadForSampleAlleles;
    private static final Logger LOGGER = Logger.getLogger(Impute2GenotypeData.class);
    private AllelesAndPhasing last;

    public Impute2GenotypeData(String path) throws IOException {
        this(new File(path + ".haps"), new File(path + ".sample"));
    }

    public Impute2GenotypeData(File hapsFile, File sampleFile) throws IOException {
        this(hapsFile, sampleFile, 100);
    }

    public Impute2GenotypeData(File hapsFile, File sampleFile, int cacheSize) throws IOException {
        this(hapsFile, sampleFile, cacheSize, null);
    }

    public Impute2GenotypeData(File hapsFile, File sampleFile, String forceSeqName) throws IOException {
        this(hapsFile, sampleFile, 100, forceSeqName);
    }

    public Impute2GenotypeData(File hapsFile, File sampleFile, int cacheSize, String forceSeqName) throws IOException {
        if (hapsFile == null) {
            throw new IllegalArgumentException("hapsFile is null");
        }
        if (!hapsFile.isFile()) {
            throw new FileNotFoundException("haps file file not found at " + hapsFile.getAbsolutePath());
        }
        if (!hapsFile.canRead()) {
            throw new IOException("Can not read haps file at " + hapsFile.getAbsolutePath());
        }
        if (sampleFile == null) {
            throw new IllegalArgumentException("sampleFile is null");
        }
        if (!sampleFile.isFile()) {
            throw new FileNotFoundException("sample file file not found at " + sampleFile.getAbsolutePath());
        }
        if (!sampleFile.canRead()) {
            throw new IOException("Can not read sample file " + sampleFile.getAbsolutePath());
        }
        this.sampleVariantProviderUniqueId = SampleVariantUniqueIdProvider.getNextUniqueId();
        this.sampleVariantProvider = cacheSize > 0 ? new CachedSampleVariantProvider(this, cacheSize) : this;
        this.loadAnnotations(sampleFile);
        LOGGER.info((Object)"Annotations loaded");
        this.samples = new ArrayList<Sample>();
        this.loadSamples(sampleFile);
        this.variants = new GeneticVariantTreeSet();
        this.variantSampleAllelesIndex = new LinkedHashMap();
        this.sequenceNames = new HashSet();
        this.hapsFileReader = new RandomAccessFile(hapsFile, "r");
        this.byteToReadForSampleAlleles = this.loadVariants(forceSeqName);
    }

    @Override
    public Iterable<Sequence> getSequences() {
        ArrayList<Sequence> sequences = new ArrayList<Sequence>();
        for (String seqName : this.getSeqNames()) {
            sequences.add(new SimpleSequence(seqName, null, this));
        }
        return sequences;
    }

    @Override
    public List<Sample> getSamples() {
        return Collections.unmodifiableList(this.samples);
    }

    private void loadSamples(File sampleFile) {
        CsvReader reader = null;
        try {
            reader = new CsvReader(sampleFile, ' ');
            Iterator it = reader.iterator();
            it.next();
            while (it.hasNext()) {
                Tuple tuple = (Tuple)it.next();
                String familyId = tuple.getString(0);
                String sampleId = tuple.getString(1);
                LinkedHashMap<String, Object> annotationValues = new LinkedHashMap<String, Object>();
                annotationValues.put("sampleMissingRateDouble", tuple.getString(2).equals("NA") ? Double.NaN : tuple.getDouble(2));
                for (String colName : this.sampleAnnotations.keySet()) {
                    if (colName.equals("sampleMissingRateDouble")) continue;
                    SampleAnnotation annotation = this.sampleAnnotations.get(colName);
                    Object value = null;
                    if (!tuple.getString(annotation.getName()).equalsIgnoreCase("NA")) {
                        switch (annotation.getType()) {
                            case STRING: {
                                value = tuple.getString(colName);
                                break;
                            }
                            case INTEGER: {
                                value = tuple.getInt(colName);
                                break;
                            }
                            case BOOLEAN: {
                                if (tuple.getString(colName).equals("-9")) {
                                    value = null;
                                    break;
                                }
                                value = tuple.getBoolean(colName);
                                break;
                            }
                            case FLOAT: {
                                value = tuple.getDouble(colName);
                                break;
                            }
                            default: {
                                LOGGER.warn((Object)("Unsupported data type encountered for column [" + colName + "]"));
                            }
                        }
                    }
                    annotationValues.put(colName, value);
                }
                this.samples.add(new Sample(sampleId, familyId, annotationValues));
            }
        }
        catch (FileNotFoundException e) {
            try {
                throw new RuntimeException("File [" + sampleFile.getAbsolutePath() + "] does not exists", e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(reader);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Closeable)reader);
    }

    @Override
    public Map<String, Annotation> getVariantAnnotationsMap() {
        return Collections.emptyMap();
    }

    @Override
    public Map<String, SampleAnnotation> getSampleAnnotationsMap() {
        return this.sampleAnnotations;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadAnnotations(File sampleFile) throws IOException {
        this.sampleAnnotations.clear();
        SampleAnnotation missingAnnotation = new SampleAnnotation("sampleMissingRateDouble", "missing", "Missing data proportion of each individual", Annotation.Type.FLOAT, SampleAnnotation.SampleAnnotationType.OTHER, false);
        this.sampleAnnotations.put(missingAnnotation.getId(), missingAnnotation);
        CsvReader reader = null;
        try {
            reader = new CsvReader(sampleFile, ' ');
            List colNames = Utils.iteratorToList(reader.colNamesIterator());
            Tuple dataTypes = (Tuple)reader.iterator().next();
            for (int i = 3; i < colNames.size(); ++i) {
                SampleAnnotation annotation = null;
                if (dataTypes.getString(i).equalsIgnoreCase("D")) {
                    annotation = new SampleAnnotation((String)colNames.get(i), (String)colNames.get(i), "", Annotation.Type.STRING, SampleAnnotation.SampleAnnotationType.COVARIATE, false);
                } else if (dataTypes.getString(i).equalsIgnoreCase("C")) {
                    annotation = new SampleAnnotation((String)colNames.get(i), (String)colNames.get(i), "", Annotation.Type.FLOAT, SampleAnnotation.SampleAnnotationType.COVARIATE, false);
                } else if (dataTypes.getString(i).equalsIgnoreCase("P")) {
                    annotation = new SampleAnnotation((String)colNames.get(i), (String)colNames.get(i), "", Annotation.Type.FLOAT, SampleAnnotation.SampleAnnotationType.PHENOTYPE, false);
                } else if (dataTypes.getString(i).equalsIgnoreCase("B")) {
                    annotation = new SampleAnnotation((String)colNames.get(i), (String)colNames.get(i), "", Annotation.Type.BOOLEAN, SampleAnnotation.SampleAnnotationType.PHENOTYPE, false);
                } else {
                    LOGGER.warn((Object)("Unknown datatype [" + dataTypes.getString(i) + "]"));
                }
                if (annotation == null) continue;
                this.sampleAnnotations.put(annotation.getId(), annotation);
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(reader);
            throw throwable;
        }
        IOUtils.closeQuietly((Closeable)reader);
    }

    @Override
    public synchronized List<Alleles> getSampleVariants(GeneticVariant variant) {
        if (this.last == null || !this.last.getVariant().equals(variant)) {
            this.last = this.loadAllelesAndPhasing(variant);
        }
        return this.last.getAlleles();
    }

    @Override
    public synchronized List<Boolean> getSamplePhasing(GeneticVariant variant) {
        if (this.last == null || !this.last.getVariant().equals(variant)) {
            this.last = this.loadAllelesAndPhasing(variant);
        }
        return this.last.getPhasing();
    }

    @Override
    public int cacheSize() {
        return 0;
    }

    @Override
    public int getSampleVariantProviderUniqueId() {
        return this.sampleVariantProviderUniqueId;
    }

    @Override
    public byte[] getSampleCalledDosage(GeneticVariant variant) {
        return CalledDosageConvertor.convertCalledAllelesToCalledDosage(this.getSampleVariants(variant), variant.getVariantAlleles(), variant.getRefAllele());
    }

    @Override
    public float[] getSampleDosage(GeneticVariant variant) {
        return CalledDosageConvertor.convertCalledAllelesToDosage(this.getSampleVariants(variant), variant.getVariantAlleles(), variant.getRefAllele());
    }

    @Override
    public void close() throws IOException {
        this.hapsFileReader.close();
    }

    @Override
    public Iterator<GeneticVariant> iterator() {
        return this.variants.iterator();
    }

    @Override
    public List<String> getSeqNames() {
        return new ArrayList<String>(this.sequenceNames);
    }

    @Override
    public Iterable<GeneticVariant> getVariantsByPos(String seqName, int startPos) {
        return this.variants.getSequencePosVariants(seqName, startPos);
    }

    @Override
    public Iterable<GeneticVariant> getSequenceGeneticVariants(String seqName) {
        return this.variants.getSequenceVariants(seqName);
    }

    @Override
    public Iterable<GeneticVariant> getVariantsByRange(String seqName, int rangeStart, int rangeEnd) {
        return this.variants.getSequenceRangeVariants(seqName, rangeStart, rangeEnd);
    }

    private int loadVariants(String forceSeqName) throws IOException {
        StringBuilder stringBuilder = new StringBuilder();
        byte[] buffer = new byte[8192];
        boolean eol = false;
        String seqName = null;
        String variantId = null;
        int position = 0;
        String allele1 = null;
        int longestedChunk = 0;
        int currentChunk = 0;
        int column = 0;
        while (!eol) {
            long posBeforeBufferRead = this.hapsFileReader.getFilePointer();
            int bytesRead = this.hapsFileReader.read(buffer);
            if (bytesRead == -1) {
                eol = true;
                continue;
            }
            block14: for (int i = 0; i < bytesRead; ++i) {
                block1 : switch (buffer[i]) {
                    case 10: 
                    case 13: {
                        if (currentChunk == 0) {
                            currentChunk = -1;
                            continue block14;
                        }
                        if (column != 5) {
                            LOGGER.fatal((Object)("Error reading haps file, did not detect first 5 columns with variant information \ncurrent column is:" + column + "\n" + "content in current column: " + stringBuilder.toString()));
                            throw new GenotypeDataException("Error reading haps file, did not detect first 5 columns with variant information");
                        }
                        longestedChunk = longestedChunk < currentChunk ? currentChunk : longestedChunk;
                        column = 0;
                        currentChunk = -1;
                        break;
                    }
                    case 32: {
                        switch (column) {
                            case 0: {
                                seqName = forceSeqName == null ? stringBuilder.toString().intern() : forceSeqName;
                                this.sequenceNames.add(seqName);
                                ++column;
                                stringBuilder = new StringBuilder();
                                break block1;
                            }
                            case 1: {
                                variantId = stringBuilder.toString();
                                ++column;
                                stringBuilder = new StringBuilder();
                                break block1;
                            }
                            case 2: {
                                try {
                                    position = Integer.parseInt(stringBuilder.toString());
                                }
                                catch (NumberFormatException ex) {
                                    throw new GenotypeDataException("Error parsing \"" + stringBuilder.toString() + "\" as position in haps file");
                                }
                                ++column;
                                stringBuilder = new StringBuilder();
                                break block1;
                            }
                            case 3: {
                                allele1 = stringBuilder.toString();
                                ++column;
                                stringBuilder = new StringBuilder();
                                break block1;
                            }
                            case 4: {
                                String allele2 = stringBuilder.toString();
                                GeneticVariant variant = ReadOnlyGeneticVariant.createVariant(variantId, position, seqName, this.sampleVariantProvider, allele1, allele2);
                                this.variants.add(variant);
                                this.variantSampleAllelesIndex.put(variant, posBeforeBufferRead + (long)i + 1L);
                                ++column;
                                stringBuilder = new StringBuilder();
                                currentChunk = -1;
                                break block1;
                            }
                        }
                        break;
                    }
                    default: {
                        if (column >= 5) break;
                        stringBuilder.append((char)buffer[i]);
                    }
                }
                ++currentChunk;
            }
        }
        return longestedChunk;
    }

    private AllelesAndPhasing loadAllelesAndPhasing(GeneticVariant geneticVariant) {
        int bytesRead;
        ArrayList<Alleles> alleles = new ArrayList<Alleles>();
        ArrayList<Boolean> phasing = new ArrayList<Boolean>();
        Alleles variantAlleles = geneticVariant.getVariantAlleles();
        long start = this.variantSampleAllelesIndex.get(geneticVariant);
        byte[] buffer = new byte[this.byteToReadForSampleAlleles];
        try {
            this.hapsFileReader.seek(start);
            bytesRead = this.hapsFileReader.read(buffer);
        }
        catch (IOException ex) {
            throw new GenotypeDataException("Error loading alleles for variant: " + geneticVariant.getPrimaryVariantId() + " from haps file");
        }
        if (bytesRead == -1) {
            throw new GenotypeDataException("Error loading alleles for variant: " + geneticVariant.getPrimaryVariantId() + " from haps file");
        }
        int i = 0;
        for (int s = 0; s < this.samples.size(); ++s) {
            Allele allele2;
            Boolean phased;
            Allele allele1;
            switch ((char)buffer[i]) {
                case '0': {
                    allele1 = variantAlleles.get(0);
                    break;
                }
                case '1': {
                    allele1 = variantAlleles.get(1);
                    break;
                }
                case '?': {
                    allele1 = Allele.ZERO;
                    break;
                }
                default: {
                    throw new GenotypeDataException("Error loading alleles for variant: " + geneticVariant.getPrimaryVariantId() + " and sample " + this.samples.get(s).getId() + " from haps file found allele: " + (char)buffer[i]);
                }
            }
            switch ((char)buffer[++i]) {
                case ' ': {
                    phased = Boolean.TRUE;
                    break;
                }
                case '*': {
                    phased = Boolean.FALSE;
                    ++i;
                    break;
                }
                default: {
                    throw new GenotypeDataException("Error loading alleles for variant: " + geneticVariant.getPrimaryVariantId() + " and sample " + this.samples.get(s).getId() + " from haps file expected space or * but found: " + (char)buffer[i]);
                }
            }
            switch ((char)buffer[++i]) {
                case '0': {
                    allele2 = variantAlleles.get(0);
                    break;
                }
                case '1': {
                    allele2 = variantAlleles.get(1);
                    break;
                }
                case '?': {
                    allele2 = Allele.ZERO;
                    break;
                }
                default: {
                    throw new GenotypeDataException("Error loading alleles for variant: " + geneticVariant.getPrimaryVariantId() + " and sample " + this.samples.get(s).getId() + " from haps file found allele: " + (char)buffer[i]);
                }
            }
            if (!phased.booleanValue()) {
                ++i;
            }
            ++i;
            ++i;
            alleles.add(Alleles.createAlleles(allele1, allele2));
            phasing.add(phased);
        }
        return new AllelesAndPhasing(geneticVariant, alleles, phasing);
    }

    private static class AllelesAndPhasing {
        private final GeneticVariant variant;
        private final List<Alleles> alleles;
        private final List<Boolean> phasing;

        public AllelesAndPhasing(GeneticVariant variant, List<Alleles> alleles, List<Boolean> phasing) {
            this.variant = variant;
            this.alleles = alleles;
            this.phasing = phasing;
        }

        public List<Alleles> getAlleles() {
            return this.alleles;
        }

        public List<Boolean> getPhasing() {
            return this.phasing;
        }

        public GeneticVariant getVariant() {
            return this.variant;
        }
    }
}

