/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.genotype;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.molgenis.genotype.annotation.CaseControlAnnotation;
import org.molgenis.genotype.annotation.SexAnnotation;

public class Sample {
    private final String id;
    private final String familyId;
    private final Map<String, Object> annotationValues;

    public Sample(String id, String familyId, Map<String, Object> annotationValues) {
        this.id = id;
        this.familyId = familyId;
        this.annotationValues = annotationValues == null ? new HashMap<String, Object>() : annotationValues;
    }

    public String getId() {
        return this.id;
    }

    public String getFamilyId() {
        return this.familyId;
    }

    public void putAnnotationValues(String annotationName, Object value) {
        this.annotationValues.put(annotationName, value);
    }

    public Map<String, ?> getAnnotationValues() {
        return Collections.unmodifiableMap(this.annotationValues);
    }

    public SexAnnotation getSex() {
        if (this.annotationValues.containsKey("sex_generic")) {
            return (SexAnnotation)((Object)this.annotationValues.get("sex_generic"));
        }
        return SexAnnotation.UNKNOWN;
    }

    public boolean isIncluded() {
        if (this.annotationValues.containsKey("sampleInclude")) {
            return (Boolean)this.annotationValues.get("sampleInclude");
        }
        return true;
    }

    public CaseControlAnnotation getCaseControlAnnotation() {
        if (this.annotationValues.containsKey("caseControl")) {
            return (CaseControlAnnotation)((Object)this.annotationValues.get("caseControl"));
        }
        return CaseControlAnnotation.UNKNOWN;
    }

    public String getFatherId() {
        if (this.annotationValues.containsKey("fatherId")) {
            return (String)this.annotationValues.get("fatherId");
        }
        return "0";
    }

    public String getMotherId() {
        if (this.annotationValues.containsKey("motherId")) {
            return (String)this.annotationValues.get("motherId");
        }
        return "0";
    }

    public double getMissingRate() {
        if (this.annotationValues.containsKey("sampleMissingRateDouble")) {
            return (Double)this.annotationValues.get("sampleMissingRateDouble");
        }
        return Double.NaN;
    }

    public String toString() {
        return "Sample [id=" + this.id + ", familyId=" + this.familyId + ", annotationValues=" + this.annotationValues + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.annotationValues == null ? 0 : ((Object)this.annotationValues).hashCode());
        result = 31 * result + (this.familyId == null ? 0 : this.familyId.hashCode());
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Sample other = (Sample)obj;
        if (this.annotationValues == null ? other.annotationValues != null : !((Object)this.annotationValues).equals(other.annotationValues)) {
            return false;
        }
        if (this.familyId == null ? other.familyId != null : !this.familyId.equals(other.familyId)) {
            return false;
        }
        return !(this.id == null ? other.id != null : !this.id.equals(other.id));
    }
}

