/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.genotype;

import java.io.Closeable;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.molgenis.genotype.AbstractRandomAccessGenotypeData;
import org.molgenis.genotype.GenotypeDataIndex;
import org.molgenis.genotype.VariantQueryResult;
import org.molgenis.genotype.util.Utils;
import org.molgenis.genotype.variant.GeneticVariant;

public abstract class IndexedGenotypeData
extends AbstractRandomAccessGenotypeData {
    @Override
    public List<String> getSeqNames() {
        return this.getIndex().getSeqNames();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<GeneticVariant> getVariantsByPos(String seqName, int startPos) {
        VariantQueryResult result = this.getIndex().createQuery().executeQuery(seqName, startPos);
        try {
            List<GeneticVariant> list = Utils.iteratorToList(result.iterator());
            return list;
        }
        finally {
            IOUtils.closeQuietly((Closeable)result);
        }
    }

    @Override
    public Iterable<GeneticVariant> getSequenceGeneticVariants(String seqName) {
        return this.getIndex().createQuery().executeQuery(seqName);
    }

    protected abstract GenotypeDataIndex getIndex();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterable<GeneticVariant> getVariantsByRange(String seqName, int rangeStart, int rangeEnd) {
        VariantQueryResult result = this.getIndex().createQuery().executeQuery(seqName, rangeStart - 1, rangeEnd - 1);
        try {
            List<GeneticVariant> list = Utils.iteratorToList(result.iterator());
            return list;
        }
        finally {
            IOUtils.closeQuietly((Closeable)result);
        }
    }
}

