/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.genotype;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.molgenis.genotype.Allele;

public class Alleles
implements Iterable<Allele>,
Comparable<Alleles> {
    private static final Map<List<Allele>, Alleles> pool = new HashMap<List<Allele>, Alleles>();
    private final List<Allele> alleles;
    private final boolean snp;
    private Alleles complement;
    private final boolean isAtOrGcSnp;
    private final List<String> allelesAsString;
    private final char[] allelesAsChar;
    private final int hashCode;

    private Alleles(List<Allele> alleles) {
        this.alleles = Collections.unmodifiableList(alleles);
        int result = 1;
        int i = 0;
        for (Allele a : alleles) {
            result += i * a.hashCode();
        }
        this.hashCode = result;
        boolean isSnp = true;
        ArrayList<String> allelesAsStringBuilder = new ArrayList<String>(alleles.size());
        for (Allele allele : alleles) {
            if (!allele.isSnpAllele()) {
                isSnp = false;
            }
            allelesAsStringBuilder.add(allele.getAlleleAsString());
        }
        this.allelesAsString = Collections.unmodifiableList(allelesAsStringBuilder);
        this.snp = isSnp;
        if (this.snp) {
            this.allelesAsChar = new char[alleles.size()];
            i = 0;
            for (Allele allele : alleles) {
                this.allelesAsChar[i] = allele.getAlleleAsSnp();
                ++i;
            }
        } else {
            this.allelesAsChar = null;
        }
        this.isAtOrGcSnp = Alleles.areAlleleCharsAtOrGc(alleles);
    }

    private static boolean areAlleleCharsAtOrGc(List<Allele> alleles) {
        if (alleles.isEmpty()) {
            return false;
        }
        boolean onlyAt = true;
        boolean onlyGc = true;
        for (Allele allele : alleles) {
            if (!allele.isSnpAllele()) {
                return false;
            }
            if (allele == Allele.A || allele == Allele.T) {
                onlyGc = false;
            }
            if (allele != Allele.C && allele != Allele.G) continue;
            onlyAt = false;
        }
        return onlyAt || onlyGc;
    }

    public static Alleles createAlleles(List<Allele> alleles) {
        if (pool.containsKey(alleles)) {
            return pool.get(alleles);
        }
        Alleles newAlleles = new Alleles(alleles);
        pool.put(alleles, newAlleles);
        newAlleles.addComplement();
        return newAlleles;
    }

    public static Alleles createAlleles(Allele ... allele) {
        return Alleles.createAlleles(Arrays.asList(allele));
    }

    public static Alleles createBasedOnString(List<String> stringAlleles) {
        ArrayList<Allele> alleles = new ArrayList<Allele>(stringAlleles.size());
        for (String stringAllele : stringAlleles) {
            alleles.add(Allele.create(stringAllele));
        }
        return Alleles.createAlleles(alleles);
    }

    public static Alleles createBasedOnString(String allele1, String allele2) {
        return Alleles.createAlleles(Allele.create(allele1), Allele.create(allele2));
    }

    public static Alleles createBasedOnChars(char allele1, char allele2) {
        return Alleles.createAlleles(Allele.create(allele1), Allele.create(allele2));
    }

    public static Alleles createBasedOnChars(char[] charAlleles) {
        ArrayList<Allele> alleles = new ArrayList<Allele>(charAlleles.length);
        for (char charAllele : charAlleles) {
            alleles.add(Allele.create(charAllele));
        }
        return Alleles.createAlleles(alleles);
    }

    private void addComplement() {
        if (this.snp) {
            ArrayList<Allele> complementAlleles = new ArrayList<Allele>(this.alleles.size());
            for (Allele allele : this.alleles) {
                complementAlleles.add(allele.getComplement());
            }
            this.complement = Alleles.createAlleles(complementAlleles);
        } else {
            this.complement = null;
        }
    }

    public List<Allele> getAlleles() {
        return this.alleles;
    }

    public List<String> getAllelesAsString() {
        return this.allelesAsString;
    }

    public int getAlleleCount() {
        return this.alleles.size();
    }

    public boolean isSnp() {
        return this.snp;
    }

    public char[] getAllelesAsChars() {
        if (!this.isSnp()) {
            throw new RuntimeException("Not a snp");
        }
        return (char[])this.allelesAsChar.clone();
    }

    public String toString() {
        return "VariantAlleles [alleles=" + this.getAllelesAsString() + ", snp=" + this.snp + "]";
    }

    public Alleles getComplement() {
        if (!this.isSnp()) {
            throw new RuntimeException("Complement currenlty only supported for SNPs");
        }
        return this.complement;
    }

    public boolean sameAlleles(Alleles other) {
        if (this == other) {
            return true;
        }
        if (this.alleles.size() != other.alleles.size()) {
            return false;
        }
        return this.alleles.containsAll(other.alleles);
    }

    public boolean isAtOrGcSnp() {
        return this.isAtOrGcSnp;
    }

    @Override
    public Iterator<Allele> iterator() {
        return this.alleles.iterator();
    }

    public Allele get(int alleleIndex) {
        return this.alleles.get(alleleIndex);
    }

    public boolean contains(Allele queryAllele) {
        return this.alleles.contains(queryAllele);
    }

    public boolean containsAll(Alleles queryAlleles) {
        for (Allele queryAllele : queryAlleles) {
            if (this.contains(queryAllele)) continue;
            return false;
        }
        return true;
    }

    @Override
    public int compareTo(Alleles other) {
        if (this == other) {
            return 0;
        }
        Iterator<Allele> thisAlleleIterator = this.alleles.iterator();
        Iterator<Allele> otherAlleleIterator = other.alleles.iterator();
        while (thisAlleleIterator.hasNext() && otherAlleleIterator.hasNext()) {
            Allele otherCurrentAllele;
            Allele thisCurrentAllele = thisAlleleIterator.next();
            if (thisCurrentAllele == (otherCurrentAllele = otherAlleleIterator.next())) continue;
            return thisCurrentAllele.compareTo(otherCurrentAllele);
        }
        if (thisAlleleIterator.hasNext()) {
            return 1;
        }
        if (otherAlleleIterator.hasNext()) {
            return -1;
        }
        return 0;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Alleles other = (Alleles)obj;
        return !(this.alleles == null ? other.alleles != null : !((Object)this.alleles).equals(other.alleles));
    }
}

