/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.genotype;

import java.util.HashMap;
import java.util.Map;
import org.molgenis.genotype.util.Utils;

public class Allele
implements Comparable<Allele> {
    private static Map<String, Allele> pool = new HashMap<String, Allele>();
    private static Map<Character, Allele> snpPool = new HashMap<Character, Allele>();
    public static final Allele A = Allele.create('A');
    public static final Allele C = Allele.create('C');
    public static final Allele G = Allele.create('G');
    public static final Allele T = Allele.create('T');
    public static final Allele ZERO = Allele.create('0');
    private final String allele;
    private final char snpAllele;
    private Allele complement;
    private final int hashCode;

    private Allele(String allele) {
        this.snpAllele = allele.length() == 1 ? (allele.charAt(0) == 'A' || allele.charAt(0) == 'C' || allele.charAt(0) == 'G' || allele.charAt(0) == 'T' || allele.charAt(0) == '0' ? allele.charAt(0) : (char)65535) : (char)65535;
        this.allele = allele;
        this.hashCode = allele.hashCode();
    }

    private Allele(char allele) {
        this(String.valueOf(allele));
    }

    public boolean isSnpAllele() {
        return (byte)this.snpAllele != -1;
    }

    public String getAlleleAsString() {
        return this.allele;
    }

    public char getAlleleAsSnp() {
        return this.snpAllele;
    }

    private void addComplement(Allele complement) {
        this.complement = complement;
    }

    public Allele getComplement() {
        if (this.isSnpAllele()) {
            return this.complement;
        }
        throw new RuntimeException("Complement currenlty only supported for SNPs");
    }

    public static Allele create(String alleleString) {
        if (alleleString == null) {
            return ZERO;
        }
        if (alleleString.isEmpty()) {
            return ZERO;
        }
        if (pool.containsKey(alleleString)) {
            return pool.get(alleleString);
        }
        alleleString = new String(alleleString);
        Allele newAllele = new Allele(alleleString);
        pool.put(alleleString, newAllele);
        if (newAllele.isSnpAllele()) {
            snpPool.put(Character.valueOf(newAllele.getAlleleAsSnp()), newAllele);
            newAllele.addComplement(Allele.create(Utils.getComplementNucleotide(newAllele.getAlleleAsSnp())));
        }
        return newAllele;
    }

    public static Allele create(char alleleChar) {
        if (alleleChar == '\u0000') {
            return ZERO;
        }
        if (snpPool.containsKey(Character.valueOf(alleleChar))) {
            return snpPool.get(Character.valueOf(alleleChar));
        }
        Allele newAllele = new Allele(alleleChar);
        snpPool.put(Character.valueOf(alleleChar), newAllele);
        pool.put(newAllele.getAlleleAsString(), newAllele);
        if (newAllele.isSnpAllele()) {
            newAllele.addComplement(Allele.create(Utils.getComplementNucleotide(alleleChar)));
        }
        return newAllele;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Allele other = (Allele)obj;
        return !(this.allele == null ? other.allele != null : !this.allele.equals(other.allele));
    }

    public String toString() {
        return this.getAlleleAsString();
    }

    @Override
    public int compareTo(Allele other) {
        return this.allele.compareTo(other.allele);
    }
}

