/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.genotype;

import java.util.HashMap;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.molgenis.genotype.AbstractGenotypeData;
import org.molgenis.genotype.RandomAccessGenotypeData;
import org.molgenis.genotype.Sequence;
import org.molgenis.genotype.variant.GeneticVariant;
import org.molgenis.genotype.variantFilter.VariantFilter;

public abstract class AbstractRandomAccessGenotypeData
extends AbstractGenotypeData
implements RandomAccessGenotypeData {
    @Override
    public Sequence getSequenceByName(String name) {
        for (Sequence sequence : this.getSequences()) {
            if (!sequence.getName().equals(name)) continue;
            return sequence;
        }
        return null;
    }

    @Override
    public GeneticVariant getSnpVariantByPos(String seqName, int startPos) {
        Iterable<GeneticVariant> variants = this.getVariantsByPos(seqName, startPos);
        for (GeneticVariant variant : variants) {
            if (!variant.isSnp()) continue;
            return variant;
        }
        return null;
    }

    @Override
    public HashMap<String, GeneticVariant> getVariantIdMap() {
        return this.getVariantIdMap(null);
    }

    @Override
    public HashMap<String, GeneticVariant> getVariantIdMap(VariantFilter filter) {
        HashMap<String, GeneticVariant> variantIdMap = new HashMap<String, GeneticVariant>();
        for (GeneticVariant variant : this) {
            if (variant.getVariantId().getPrimairyId() == null || variant.getPrimaryVariantId().equals("") || filter != null && !filter.doesVariantPassFilter(variant)) continue;
            variantIdMap.put(variant.getPrimaryVariantId(), variant);
        }
        return variantIdMap;
    }

    @Override
    public Iterator<GeneticVariant> iterator() {
        return new GeneticVariantsIterator(this);
    }

    private static class GeneticVariantsIterator
    implements Iterator<GeneticVariant> {
        private Iterator<String> seqNames;
        private Iterator<GeneticVariant> seqGeneticVariants;
        private RandomAccessGenotypeData randomAccessGenotypeData;

        public GeneticVariantsIterator(RandomAccessGenotypeData randomAccessGenotypeData) {
            this.seqNames = randomAccessGenotypeData.getSeqNames().iterator();
            this.seqGeneticVariants = randomAccessGenotypeData.getSequenceGeneticVariants(this.seqNames.next()).iterator();
            this.randomAccessGenotypeData = randomAccessGenotypeData;
        }

        @Override
        public boolean hasNext() {
            return this.seqGeneticVariants.hasNext() || this.seqNames.hasNext();
        }

        @Override
        public GeneticVariant next() {
            if (this.seqGeneticVariants.hasNext()) {
                return this.seqGeneticVariants.next();
            }
            if (this.seqNames.hasNext()) {
                this.seqGeneticVariants = this.randomAccessGenotypeData.getSequenceGeneticVariants(this.seqNames.next()).iterator();
                return this.seqGeneticVariants.next();
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

