/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.util.trityper.reader;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.HashMap;
import org.molgenis.util.trityper.reader.ChrAnnotation;
import org.molgenis.util.trityper.reader.Gpio;
import org.molgenis.util.trityper.reader.SNP;
import org.molgenis.util.trityper.reader.SNPLoader;
import org.molgenis.util.trityper.reader.TextFile;

public class TriTyperGenotypeData {
    private String[] SNPs;
    private Boolean[] isFemale;
    private Boolean[] isCase;
    private Boolean[] isIncluded;
    private String[] individuals;
    private HashMap<String, Integer> individualToId;
    private HashMap<String, Integer> snpToSNPId;
    private String genotypeFileName;
    private String dosageFileName;
    private byte[] chr;
    private int[] chrPos;

    public void load(String loc) throws IOException, Exception {
        if (!loc.endsWith("/")) {
            loc = loc + "/";
        }
        this.checkFiles(loc);
        TextFile t = new TextFile(loc + "Individuals.txt", false);
        String[] lineElems = t.readLineElems(TextFile.tab);
        ArrayList<String> alInd = new ArrayList<String>();
        int i = 0;
        this.individualToId = new HashMap();
        while (lineElems != null) {
            String individual = lineElems[0];
            this.individualToId.put(individual, i);
            alInd.add(individual);
            ++i;
            lineElems = t.readLineElems(TextFile.tab);
        }
        t.close();
        int numInds = this.individualToId.size();
        this.setIsFemale(new Boolean[numInds]);
        this.setIsCase(new Boolean[numInds]);
        this.setIsIncluded(new Boolean[numInds]);
        this.individuals = new String[numInds];
        for (i = 0; i < numInds; ++i) {
            this.getIsFemale()[i] = null;
            this.getIsCase()[i] = null;
            this.getIsIncluded()[i] = null;
            this.individuals[i] = (String)alInd.get(i);
        }
        alInd = null;
        t = new TextFile(loc + "PhenotypeInformation.txt", false);
        int numMales = 0;
        int numFemales = 0;
        int numCases = 0;
        int numControls = 0;
        int numIncluded = 0;
        lineElems = t.readLineElems(TextFile.tab);
        alInd = new ArrayList();
        while (lineElems != null) {
            String ind = lineElems[0];
            Integer indId = this.individualToId.get(ind);
            if (indId != null) {
                if (lineElems[1].equals("control")) {
                    this.isCase[indId.intValue()] = false;
                    ++numControls;
                } else if (lineElems[1].equals("case")) {
                    this.isCase[indId.intValue()] = true;
                    ++numCases;
                } else {
                    System.err.println("Warning: case/control status unparseable for\t" + lineElems[1] + "\tfor\t" + indId);
                }
                if (lineElems[2].equals("exclude")) {
                    this.isIncluded[indId.intValue()] = false;
                } else if (lineElems[2].equals("include")) {
                    this.isIncluded[indId.intValue()] = true;
                    ++numIncluded;
                } else {
                    System.err.println("Warning: include/exclude status unparseable\t" + lineElems[2] + "\tfor\t" + indId);
                }
                if (lineElems[3].equals("male")) {
                    this.isFemale[indId.intValue()] = false;
                    ++numMales;
                } else if (lineElems[3].equals("female")) {
                    this.isFemale[indId.intValue()] = true;
                    ++numFemales;
                } else {
                    System.err.println("Warning: gender status unparseable\t" + lineElems[3] + "\tfor\t" + indId);
                }
            }
            lineElems = t.readLineElems(TextFile.tab);
        }
        t.close();
        System.out.println(numInds + " individuals detected, " + numMales + " males, " + numFemales + " females, " + numCases + " cases, " + numControls + " controls, " + numIncluded + " included");
        t = new TextFile(loc + "SNPs.txt", false);
        String line = t.readLine();
        alInd = new ArrayList();
        int snpId = 0;
        ArrayList<String> tmpSNP = new ArrayList<String>();
        this.snpToSNPId = new HashMap();
        while (line != null) {
            if (line.trim().length() > 0) {
                String snp = line;
                this.snpToSNPId.put(snp, snpId);
                tmpSNP.add(snp);
                ++snpId;
            }
            line = t.readLine();
        }
        this.SNPs = new String[snpId];
        for (i = 0; i < tmpSNP.size(); ++i) {
            this.SNPs[i] = (String)tmpSNP.get(i);
        }
        t.close();
        System.out.println(this.SNPs.length + " snps loaded");
        t = new TextFile(loc + "SNPMappings.txt", false);
        lineElems = t.readLineElems(TextFile.tab);
        alInd = new ArrayList();
        this.chr = new byte[this.SNPs.length];
        this.chrPos = new int[this.SNPs.length];
        while (lineElems != null) {
            String snpStr;
            Integer snpNum;
            if (lineElems.length > 2 && (snpNum = this.snpToSNPId.get(snpStr = lineElems[2])) != null) {
                this.chr[snpNum.intValue()] = ChrAnnotation.parseChr(lineElems[0]);
                this.chrPos[snpNum.intValue()] = Integer.parseInt(lineElems[1]);
            }
            lineElems = t.readLineElems(TextFile.tab);
        }
        t.close();
        this.setGenotypeFileName(loc + "GenotypeMatrix.dat");
        this.setDosageFileName(loc + "ImputedDosageMatrix.dat");
    }

    public Boolean[] getIsFemale() {
        return this.isFemale;
    }

    public void setIsFemale(Boolean[] isFemale) {
        this.isFemale = isFemale;
    }

    public Boolean[] getIsCase() {
        return this.isCase;
    }

    public void setIsCase(Boolean[] isCase) {
        this.isCase = isCase;
    }

    public Boolean[] getIsIncluded() {
        return this.isIncluded;
    }

    public void setIsIncluded(Boolean[] isIncluded) {
        this.isIncluded = isIncluded;
    }

    public HashMap<String, Integer> getIndividualToId() {
        return this.individualToId;
    }

    public void setIndividualToId(HashMap<String, Integer> individualToId) {
        this.individualToId = individualToId;
    }

    public HashMap<String, Integer> getSnpToSNPId() {
        return this.snpToSNPId;
    }

    public void setSnpToSNPObject(HashMap<String, Integer> snpToSNPObject) {
        this.snpToSNPId = snpToSNPObject;
    }

    public String getGenotypeFileName() {
        return this.genotypeFileName;
    }

    public void setGenotypeFileName(String genotypeFileName) {
        this.genotypeFileName = genotypeFileName;
    }

    public String getDosageFileName() {
        return this.dosageFileName;
    }

    public void setDosageFileName(String dosageFileName) {
        this.dosageFileName = dosageFileName;
    }

    public String[] getSNPs() {
        return this.SNPs;
    }

    public void setSNPs(String[] SNPs) {
        this.SNPs = SNPs;
    }

    public String[] getIndividuals() {
        return this.individuals;
    }

    private void checkFiles(String loc) throws Exception {
        if (!Gpio.exists(loc)) {
            throw new Exception("Error: Directory " + loc + " does not exist.");
        }
        if (!Gpio.exists(loc + "PhenotypeInformation.txt")) {
            throw new Exception("Error: Required file " + loc + "PhenotypeInformation.txt does not exist.");
        }
        if (!Gpio.exists(loc + "Individuals.txt")) {
            throw new Exception("Error: Required file " + loc + "Individuals.txt does not exist.");
        }
        if (!Gpio.exists(loc + "SNPMappings.txt")) {
            throw new Exception("Error: Required file " + loc + "SNPMappings.txt does not exist.");
        }
    }

    public Integer getIndividualId(String key) {
        return this.individualToId.get(key);
    }

    public Byte getChr(int s) {
        return this.chr[s];
    }

    public int getChrPos(int s) {
        return this.chrPos[s];
    }

    public SNP getSNPObject(int d) {
        SNP out = new SNP();
        out.setId(d);
        out.setChr(this.chr[d]);
        out.setChrPos(this.chrPos[d]);
        out.setName(this.SNPs[d]);
        return out;
    }

    public SNPLoader createSNPLoader() throws IOException {
        RandomAccessFile dosageHandle = null;
        RandomAccessFile genotypeHandle = new RandomAccessFile(this.genotypeFileName, "r");
        if (Gpio.exists(this.dosageFileName)) {
            dosageHandle = new RandomAccessFile(this.dosageFileName, "r");
        }
        SNPLoader s = new SNPLoader(genotypeHandle, dosageHandle, this.isIncluded, this.isFemale);
        s.setNumIndividuals(this.individuals.length);
        return s;
    }
}

