/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.io;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipFile;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.molgenis.io.TableReader;
import org.molgenis.io.TupleReader;
import org.molgenis.io.ZipTableReader;
import org.molgenis.io.csv.CsvReader;
import org.molgenis.io.excel.ExcelReader;

public class TableReaderFactory {
    private TableReaderFactory() {
    }

    public static TableReader create(File file) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException("file is null");
        }
        if (!file.isFile()) {
            throw new IllegalArgumentException("file is not a file: " + file.getName());
        }
        return TableReaderFactory.createTableReader(file);
    }

    public static TableReader create(List<File> files) throws IOException {
        if (files == null || files.isEmpty()) {
            throw new IllegalArgumentException("files is null or empty");
        }
        AggregateTableReader tableReader = new AggregateTableReader();
        for (File file : files) {
            tableReader.addTableReader(TableReaderFactory.createTableReader(file));
        }
        return tableReader;
    }

    private static TableReader createTableReader(File file) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException("file is null");
        }
        String name = file.getName();
        if (name.endsWith(".csv") || name.endsWith(".txt")) {
            String tableName = FilenameUtils.getBaseName((String)name);
            return new SingleTableReader(new CsvReader(file), tableName);
        }
        if (name.endsWith(".tsv")) {
            String tableName = FilenameUtils.getBaseName((String)name);
            return new SingleTableReader(new CsvReader(file, '\t'), tableName);
        }
        if (name.endsWith(".xls") || name.endsWith(".xlsx")) {
            return new ExcelReader(file);
        }
        if (name.endsWith(".zip")) {
            return new ZipTableReader(new ZipFile(file));
        }
        throw new IOException("unknown file type: " + name);
    }

    private static class AggregateTableReader
    implements TableReader {
        private final List<TableReader> tableReaders = new ArrayList<TableReader>();
        private final Map<String, TupleReader> tupleReaders = new LinkedHashMap<String, TupleReader>();

        @Override
        public Iterator<TupleReader> iterator() {
            return Collections.unmodifiableCollection(this.tupleReaders.values()).iterator();
        }

        public void addTableReader(TableReader tableReader) throws IOException {
            this.tableReaders.add(tableReader);
            for (String tableName : tableReader.getTableNames()) {
                this.tupleReaders.put(tableName, tableReader.getTupleReader(tableName));
            }
        }

        @Override
        public void close() throws IOException {
            for (TableReader tableReader : this.tableReaders) {
                IOUtils.closeQuietly((Closeable)tableReader);
            }
        }

        @Override
        public TupleReader getTupleReader(String tableName) throws IOException {
            return this.tupleReaders.get(tableName);
        }

        @Override
        public Iterable<String> getTableNames() throws IOException {
            return Collections.unmodifiableSet(this.tupleReaders.keySet());
        }
    }

    private static class SingleTableReader
    implements TableReader {
        private final TupleReader tupleReader;
        private final String tableName;

        public SingleTableReader(TupleReader tupleReader, String tableName) {
            if (tupleReader == null) {
                throw new IllegalArgumentException("tuple reader is null");
            }
            if (tableName == null) {
                throw new IllegalArgumentException("table name is null");
            }
            this.tupleReader = tupleReader;
            this.tableName = tableName;
        }

        @Override
        public Iterator<TupleReader> iterator() {
            return Collections.singletonList(this.tupleReader).iterator();
        }

        @Override
        public void close() throws IOException {
            this.tupleReader.close();
        }

        @Override
        public TupleReader getTupleReader(String tableName) throws IOException {
            return this.tableName.equals(tableName) ? this.tupleReader : null;
        }

        @Override
        public Iterable<String> getTableNames() throws IOException {
            return Collections.singletonList(this.tableName);
        }
    }
}

