/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.generators.ui;

import freemarker.template.Template;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.Map;
import org.apache.log4j.Logger;
import org.molgenis.MolgenisOptions;
import org.molgenis.generators.Generator;
import org.molgenis.model.elements.Model;
import org.molgenis.model.elements.Plugin;
import org.molgenis.model.elements.UISchema;

public class EasyPluginControllerGen
extends Generator {
    private static final Logger logger = Logger.getLogger(EasyPluginControllerGen.class);

    @Override
    public String getDescription() {
        return "Generates in the handwritten folder a template of an FTL.";
    }

    @Override
    public void generate(Model model, MolgenisOptions options) throws Exception {
        this.generateForm(model, options, model.getUserinterface());
    }

    private void generateForm(Model model, MolgenisOptions options, UISchema schema) throws Exception {
        if (!options.generate_tests) {
            Template template = this.createTemplate("/" + this.getClass().getSimpleName() + ".java.ftl");
            Map<String, Object> templateArgs = this.createTemplateArguments(options);
            for (UISchema screen : schema.getChildren()) {
                if (screen.getClass() == Plugin.class) {
                    String fullKlazzName;
                    Plugin plugin = (Plugin)screen;
                    String packageName = fullKlazzName = plugin.getPluginType();
                    if (fullKlazzName.contains(".")) {
                        packageName = fullKlazzName.substring(0, fullKlazzName.lastIndexOf("."));
                    }
                    String shortKlazzName = fullKlazzName;
                    if (fullKlazzName.contains(".")) {
                        shortKlazzName = fullKlazzName.substring(fullKlazzName.lastIndexOf(".") + 1);
                    }
                    File targetFile = new File(this.getHandWrittenPath(options) + "/" + fullKlazzName.replace(".", "/") + ".java");
                    File targetFtl = new File(fullKlazzName.replace(".", "/") + ".ftl");
                    Class<?> c = null;
                    try {
                        c = Class.forName(fullKlazzName);
                    }
                    catch (ClassNotFoundException e) {
                        logger.debug((Object)("skipped plugin " + plugin.getName() + " as it is on the classpath"));
                    }
                    logger.debug((Object)("tested classforname on " + fullKlazzName + ": " + c));
                    if (!targetFile.exists() && c == null) {
                        File targetDir = new File(this.getHandWrittenPath(options) + "/" + packageName.replace(".", "/"));
                        boolean created = targetDir.mkdirs();
                        if (!created && !targetDir.exists()) {
                            throw new IOException("could not create " + targetDir);
                        }
                        templateArgs.put("screen", plugin);
                        templateArgs.put("template", template.getName());
                        templateArgs.put("clazzName", shortKlazzName);
                        templateArgs.put("macroName", fullKlazzName.replace(".", "_"));
                        templateArgs.put("templatePath", targetFtl.toString().replace("\\", "/"));
                        templateArgs.put("package", packageName);
                        templateArgs.put("flavor", plugin.getFlavor().toString().toLowerCase());
                        FileOutputStream targetOut = new FileOutputStream(targetFile);
                        template.process(templateArgs, (Writer)new OutputStreamWriter((OutputStream)targetOut, Charset.forName("UTF-8")));
                        ((OutputStream)targetOut).close();
                        logger.info((Object)("generated " + targetFile.getAbsolutePath().substring(this.getHandWrittenPath(options).length())));
                    } else {
                        logger.warn((Object)("Skipped because exists: " + targetFile));
                    }
                }
                this.generateForm(model, options, screen);
            }
        }
    }
}

