/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.generators.doc;

import freemarker.template.Template;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.molgenis.MolgenisOptions;
import org.molgenis.generators.Generator;
import org.molgenis.model.MolgenisModel;
import org.molgenis.model.elements.Entity;
import org.molgenis.model.elements.Model;
import org.molgenis.model.elements.Module;

public class TextUmlGen
extends Generator {
    private static final Logger logger = Logger.getLogger(TextUmlGen.class);

    @Override
    public String getDescription() {
        return "Generates textUML compatible file.";
    }

    @Override
    public void generate(Model model, MolgenisOptions options) throws Exception {
        if (!options.generate_tests) {
            Template template = this.createTemplate("/" + this.getClass().getSimpleName() + ".java.ftl");
            Map<String, Object> templateArgs = this.createTemplateArguments(options);
            File target = new File(this.getDocumentationPath(options) + "/textUML.txt");
            boolean created = target.getParentFile().mkdirs();
            if (!created && !target.getParentFile().exists()) {
                throw new IOException("could not create " + target.getParentFile());
            }
            List<Entity> entityList = model.getEntities();
            List<Module> moduleList = model.getModules();
            entityList = MolgenisModel.sortEntitiesByDependency(entityList, model);
            templateArgs.put("model", model);
            templateArgs.put("entities", entityList);
            templateArgs.put("modules", moduleList);
            FileOutputStream targetOut = new FileOutputStream(target);
            template.process(templateArgs, (Writer)new OutputStreamWriter((OutputStream)targetOut, Charset.forName("UTF-8")));
            ((OutputStream)targetOut).close();
            logger.info((Object)("generated " + target));
        }
    }
}

