/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.generators.cpp;

import freemarker.template.Template;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.molgenis.MolgenisOptions;
import org.molgenis.generators.Generator;
import org.molgenis.model.MolgenisModel;
import org.molgenis.model.elements.Entity;
import org.molgenis.model.elements.Model;

public class MakeFileGen
extends Generator {
    private static final Logger logger = Logger.getLogger(MakeFileGen.class);

    @Override
    public String getDescription() {
        return "Generates CPP cmake file";
    }

    @Override
    public void generate(Model model, MolgenisOptions options) throws Exception {
        if (!options.generate_tests) {
            Template template = this.createTemplate("/" + this.getClass().getSimpleName() + ".cmake.ftl");
            Map<String, Object> templateArgs = this.createTemplateArguments(options);
            Vector<Entity> entityList = model.getEntities();
            MolgenisModel.sortEntitiesByDependency(entityList, model);
            File target = new File(this.getCPPSourcePath(options) + "/CMakeLists.txt");
            boolean created = target.getParentFile().mkdirs();
            if (!created && !target.getParentFile().exists()) {
                throw new IOException("could not create " + target.getParentFile());
            }
            templateArgs.put("model", model);
            templateArgs.put("entities", entityList);
            templateArgs.put("JavaHome", System.getProperty("java.home").toString());
            templateArgs.put("UserHome", System.getProperty("user.dir").replace("\\", "/").toString());
            templateArgs.put("EXECNAME", "${EXECNAME}".toString());
            templateArgs.put("EXECUTABLE", "${EXECUTABLE}".toString());
            FileOutputStream targetOut = new FileOutputStream(target);
            template.process(templateArgs, (Writer)new OutputStreamWriter((OutputStream)targetOut, Charset.forName("UTF-8")));
            ((OutputStream)targetOut).close();
            logger.info((Object)("generated " + target));
        }
    }
}

