/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.framework.ui.html.render;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.molgenis.framework.ui.html.render.RenderDecorator;

public class LinkoutRenderDecorator
implements RenderDecorator {
    Map<String, String> mypatterns = new HashMap<String, String>();

    public LinkoutRenderDecorator() {
        this.mypatterns.put("K[0-9]{5}", "http://www.genome.jp/dbget-bin/www_bget?");
        this.mypatterns.put("LOC[0-9]{6}", "http://www.ncbi.nlm.nih.gov/gene?term=");
        this.mypatterns.put("N[CGTW]{1}_[0-9]{6}.[0-9]+", "http://www.ncbi.nlm.nih.gov/sites/gquery?term=");
        this.mypatterns.put("AC_[0-9]{6}.[0-9]+", "http://www.ncbi.nlm.nih.gov/sites/gquery?term=");
        this.mypatterns.put("AC[0-9]{6}.[0-9]+", "http://www.ncbi.nlm.nih.gov/sites/gquery?term=");
        this.mypatterns.put("A[tT][0-9]{1}[gG][0-9]{4,6}", "http://www.arabidopsis.org/servlets/Search?type=general&search_action=detail&method=1&show_obsolete=F&sub_type=gene&SEARCH_EXACT=4&SEARCH_CONTAINS=1&name=");
        this.mypatterns.put("CS[0-9]{5}", "http://www.arabidopsis.org/servlets/Search?type=general&search_action=detail&method=1&show_obsolete=F&sub_type=germplasm&SEARCH_EXACT=4&SEARCH_CONTAINS=1&name=");
        this.mypatterns.put("WBGene[0-9]{8}", "http://www.wormbase.org/db/gene/gene?class=Gene&name=");
        this.mypatterns.put("ENSRNOG[0-9]+", "http://www.ensembl.org/Rattus_norvegicus/Gene/Summary?g=");
        this.mypatterns.put("(http|https?|ftp|file)://[-a-zA-Z0-9+&@#/%?=~_|!:,.;]*[-a-zA-Z0-9+&@#/%=~_|]", "");
    }

    @Override
    public String render(String in) {
        String out = in;
        for (String key : this.mypatterns.keySet()) {
            StringBuffer sb = new StringBuffer();
            Pattern pattern = Pattern.compile(key);
            Matcher matcher = pattern.matcher(out);
            while (matcher.find()) {
                matcher.appendReplacement(sb, "<a target=\"_blank\" href=" + this.mypatterns.get(key) + matcher.group() + ">" + matcher.group() + "</a>");
            }
            matcher.appendTail(sb);
            out = sb.toString();
        }
        return out;
    }
}

