/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.framework.ui.html;

import java.text.ParseException;
import java.util.UUID;
import org.apache.commons.lang3.StringEscapeUtils;
import org.molgenis.framework.ui.html.AbstractHtmlElement;
import org.molgenis.framework.ui.html.HtmlElement;
import org.molgenis.framework.ui.html.HtmlInputException;
import org.molgenis.framework.ui.html.HtmlSettings;
import org.molgenis.framework.ui.html.Input;
import org.molgenis.framework.ui.html.render.RenderDecorator;
import org.molgenis.util.tuple.Tuple;

public abstract class HtmlInput<E>
extends AbstractHtmlElement
implements Input<E>,
HtmlElement {
    public static final String NAME = "name";
    public static final String LABEL = "label";
    public static final String VALUE = "value";
    public static final String NILLABLE = "nillable";
    public static final String READONLY = "readonly";
    public static final String DESCRIPTION = "decription";
    public static final String HIDDEN = "hidden";
    public static final String JQUERYPROPERTIES = "Jqueryproperties";
    private String id;
    private String name;
    private E value;
    private String label;
    private boolean readonly;
    protected boolean hidden;
    private boolean nillable = true;
    private boolean collapse = false;
    private String tooltip;
    private String style;
    private Integer size;
    private String target = "";
    private String description = "";
    private String Jqueryproperties;
    protected String tabIndex = "";
    protected HtmlElement.UiToolkit uiToolkit = HtmlSettings.uiToolkit;
    protected RenderDecorator renderDecorator = HtmlSettings.defaultRenderDecorator;

    public HtmlInput(String name, E value) {
        if (name == null) {
            name = UUID.randomUUID().toString().replace("-", "");
        }
        this.setId(name.replace(" ", ""));
        this.setName(name.replace(" ", ""));
        this.setLabel(name);
        this.setId(name);
        this.setValue(value);
    }

    public HtmlInput(String name, String label, E value) {
        if (name == null) {
            throw new IllegalArgumentException("name is null");
        }
        this.setId(name.replace(" ", ""));
        this.setName(name.replace(" ", ""));
        this.setLabel(label);
        this.setId(name);
        this.setValue(value);
    }

    public HtmlInput(String name, String label, E value, boolean nillable, boolean readonly, String description) {
        this(name, value);
        this.setLabel(label);
        this.setNillable(nillable);
        this.setReadonly(readonly);
        this.setDescription(description);
    }

    public HtmlInput(Tuple properties) throws HtmlInputException {
        this.set(properties);
    }

    @Override
    public void set(Tuple t) throws HtmlInputException {
        this.id = t.getString(NAME);
        this.name = t.getString(NAME);
        this.label = t.getString(LABEL);
        this.value = t.get(VALUE);
        if (t.getBoolean(NILLABLE) != null) {
            this.nillable = t.getBoolean(NILLABLE);
        }
        if (t.getBoolean(READONLY) != null) {
            this.readonly = t.getBoolean(READONLY);
        }
        this.description = t.getString(DESCRIPTION);
        if (t.getBoolean(HIDDEN) != null) {
            this.hidden = t.getBoolean(HIDDEN);
        }
        this.Jqueryproperties = t.getString(JQUERYPROPERTIES);
    }

    protected HtmlInput() {
        this(UUID.randomUUID().toString(), null);
    }

    public abstract String toHtml();

    public String getLabel() {
        if (this.label != null) {
            return this.label;
        }
        return this.name;
    }

    public HtmlInput<E> setLabel(String label) {
        this.label = label;
        return this;
    }

    public String getName() {
        if (this.name == null) {
            return this.getId();
        }
        return this.name;
    }

    public HtmlInput<E> setName(String name) {
        this.name = name;
        return this;
    }

    public E getObject() {
        return this.value;
    }

    public String getObjectString() {
        if (this.value == null) {
            return "";
        }
        return this.value.toString();
    }

    public String getValue() {
        return this.getValue(false);
    }

    public String getValue(boolean replaceSpecialChars) {
        if (this.getObject() == null) {
            return "";
        }
        return this.getObject().toString();
    }

    public String getHtmlValue(int maxLength) {
        StringBuilder strBuilder = new StringBuilder();
        boolean inTag = false;
        int count = 0;
        for (char c : this.getHtmlValue().toCharArray()) {
            if ('<' == c) {
                inTag = true;
            }
            if (inTag || count < maxLength) {
                strBuilder.append(c);
            }
            if ('>' == c) {
                inTag = false;
            }
            if (inTag) continue;
            ++count;
        }
        return strBuilder.toString();
    }

    public String getHtmlValue() {
        String value = null;
        value = this.getValue();
        return this.renderDecorator.render(value);
    }

    public String getJavaScriptValue() {
        String value = StringEscapeUtils.escapeXml((String)StringEscapeUtils.escapeEcmaScript((String)this.getValue()));
        return value;
    }

    @Deprecated
    public String toHtml(Tuple params) throws ParseException, HtmlInputException {
        throw new UnsupportedOperationException();
    }

    @Override
    public String render(Tuple params) throws ParseException, HtmlInputException {
        return this.toHtml(params);
    }

    @Override
    public String render() {
        return this.toHtml();
    }

    @Override
    public String getCustomHtmlHeaders() {
        return null;
    }

    public HtmlInput<E> setValue(E value) {
        this.value = value;
        return this;
    }

    public boolean isReadonly() {
        return this.readonly;
    }

    public HtmlInput<E> setReadonly(boolean readonly) {
        this.readonly = readonly;
        return this;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public HtmlInput<E> setHidden(boolean hidden) {
        this.hidden = hidden;
        return this;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    public String getStyle() {
        return this.style;
    }

    public HtmlInput<E> setStyle(String style) {
        this.style = style;
        return this;
    }

    public String getTooltip() {
        return this.tooltip;
    }

    public HtmlInput<E> setTooltip(String tooltip) {
        this.tooltip = tooltip;
        return this;
    }

    public String getTarget() {
        return this.target.replace(".", "_");
    }

    public HtmlInput<E> setTarget(String target) {
        this.target = target.replace(".", "_");
        return this;
    }

    public String getDescription() {
        return this.description;
    }

    public HtmlInput<E> setDescription(String description) {
        this.description = description;
        return this;
    }

    public boolean isNillable() {
        return this.nillable;
    }

    public HtmlInput<E> setNillable(boolean required) {
        this.nillable = required;
        return this;
    }

    public String getJqueryproperties() {
        return this.Jqueryproperties;
    }

    public void setJqueryproperties(String jqueryproperties) {
        this.Jqueryproperties = jqueryproperties;
    }

    public boolean isCollapse() {
        return this.collapse;
    }

    public void setCollapse(boolean collapse) {
        this.collapse = collapse;
    }

    public String toString() {
        return this.toHtml();
    }

    public String getHtml() {
        return this.toHtml();
    }

    public synchronized Integer getSize() {
        return this.size;
    }

    public synchronized HtmlInput<E> setSize(Integer size) {
        this.size = size;
        return this;
    }

    public HtmlInput<E> setTabIndex(int tabidx) {
        this.tabIndex = " tabindex=" + Integer.toString(tabidx);
        return this;
    }

    public HtmlElement.UiToolkit getUiToolkit() {
        return this.uiToolkit;
    }
}

