/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.framework.ui.html;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import org.molgenis.framework.ui.html.HtmlElement;
import org.molgenis.framework.ui.html.HtmlInput;
import org.molgenis.framework.ui.html.HtmlInputException;
import org.molgenis.framework.ui.html.StringInput;
import org.molgenis.util.tuple.Tuple;

public class DatetimeInput
extends HtmlInput<Date> {
    public DatetimeInput(String name) {
        super(name, null);
    }

    public DatetimeInput(String name, Date value) {
        super(name, value);
    }

    public DatetimeInput(String name, String label, Date value) {
        super(name, label, value);
    }

    public DatetimeInput(String name, String label, Date value, boolean nillable, boolean readonly) {
        super(name, value);
        if (label != null && !label.equals("null")) {
            this.setLabel(label);
        }
        this.setReadonly(readonly);
        this.setNillable(nillable);
    }

    public DatetimeInput(Tuple properties) throws HtmlInputException {
        super(properties);
    }

    @Override
    public String toHtml() {
        if (this.isHidden()) {
            StringInput input = new StringInput(this.getName(), this.getValue());
            input.setHidden(true);
            return input.toHtml();
        }
        if (this.uiToolkit == HtmlElement.UiToolkit.ORIGINAL) {
            return this.toDefault();
        }
        if (this.uiToolkit == HtmlElement.UiToolkit.JQUERY) {
            return this.toJquery();
        }
        return "NOT IMPLEMENTED FOR LIBRARY " + (Object)((Object)this.uiToolkit);
    }

    private String toDefault() {
        String readonly = this.isReadonly() ? " class=\"readonly\" readonly=\"readonly\" " : "onclick=\"showDateInput(this,true) ";
        return "<input type=\"text\" id=\"" + this.getId() + "\" name=\"" + this.getName() + "\"  size=\"32\" value=\"" + this.getValue() + "\" " + readonly + "\" autocomplete=\"off\"/>";
    }

    public String toJquery() {
        String description = this.getName().equals(this.getDescription()) ? "" : " title=\"" + this.getDescription() + "\"";
        String options = "dateFormat: 'yy-mm-dd', timeFormat: 'hh:mm:ss', changeMonth: true, changeYear: true, showButtonPanel: true";
        String createScript = "function( input ) {setTimeout(function() {var buttonPane = $( input ).datetimepicker( \"widget\" ).find( \".ui-datepicker-buttonpane\" );$( \"<button>\", {text: \"Clear\", click: function() { $(input).datetimepicker( 'setDate', null );}}).addClass(\"ui-datepicker-close ui-state-default ui-priority-secondary ui-corner-all\").appendTo( buttonPane );}, 1 );}";
        if (this.isNillable()) {
            options = options + ", beforeShow: " + createScript;
        }
        String validate = "";
        if (!this.isNillable()) {
            validate = " required";
        }
        String result = "<input type=\"text\" readonly=\"readonly\" class=\"" + (this.isReadonly() ? "readonly " : "") + "text ui-widget-content ui-corner-all" + validate + "\" id=\"" + this.getName() + "\" value=\"" + this.getValue("yyyy-MM-dd HH:mm:ss") + "\" name=\"" + this.getName() + "\" autocomplete=\"off\" " + description + "/>";
        if (!this.isReadonly()) {
            result = result + "<script>$(\"#" + this.getName() + "\").bt().datetimepicker({" + options + "}).click(function(){$(this).datetimepicker('show')});</script>";
        }
        return result;
    }

    public String getValue(String format) {
        String result;
        SimpleDateFormat formatter = new SimpleDateFormat(format, Locale.US);
        Object dateObject = this.getObject();
        if (dateObject == null) {
            return "";
        }
        if (dateObject.equals("")) {
            return "";
        }
        if (dateObject instanceof String) {
            return dateObject.toString();
        }
        try {
            result = formatter.format(dateObject);
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
        result = result.substring(0, 1).toUpperCase() + result.substring(1);
        return result;
    }

    @Override
    public String getValue() {
        return this.getValue("MMMM d, yyyy, HH:mm:ss");
    }

    @Override
    public String toHtml(Tuple p) throws HtmlInputException {
        return new DatetimeInput(p).render();
    }
}

