/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.framework.ui;

import java.io.OutputStream;
import java.util.Vector;
import org.molgenis.framework.db.Database;
import org.molgenis.framework.db.DatabaseException;
import org.molgenis.framework.security.Login;
import org.molgenis.framework.server.MolgenisRequest;
import org.molgenis.framework.server.TokenFactory;
import org.molgenis.framework.ui.ApplicationController;
import org.molgenis.framework.ui.ScreenController;
import org.molgenis.framework.ui.ScreenMessage;
import org.molgenis.framework.ui.ScreenModel;
import org.molgenis.framework.ui.ScreenView;
import org.molgenis.framework.ui.SimpleScreenController;
import org.molgenis.util.Entity;
import org.molgenis.util.HandleRequestDelegationException;

public abstract class PluginModel<E extends Entity>
extends SimpleScreenController<ScreenModel>
implements ScreenModel {
    private static final long serialVersionUID = -6748634936592503575L;
    private String label;
    private String selected;
    private Vector<ScreenMessage> messages = new Vector();

    public PluginModel(String name, ScreenController<?> parent) {
        super(name, null, parent);
        this.setModel(this);
        this.setLabel(this.getName().substring(this.getName().lastIndexOf("_") + 1));
    }

    @Override
    public ScreenView getView() {
        throw new UnsupportedOperationException();
    }

    public Login getLogin() {
        return this.getApplicationController().getLogin();
    }

    public TokenFactory getTokenFactory() {
        return this.getController().getApplicationController().getMolgenisContext().getTokenFactory();
    }

    public void handleRequest(Database db, MolgenisRequest request) throws HandleRequestDelegationException, Exception {
    }

    @Override
    public ScreenModel.Show handleRequest(Database db, MolgenisRequest request, OutputStream out) throws HandleRequestDelegationException, Exception {
        this.handleRequest(db, request);
        return ScreenModel.Show.SHOW_MAIN;
    }

    @Override
    public boolean isVisible() {
        try {
            return this.getLogin().canRead(this.getController());
        }
        catch (DatabaseException e) {
            e.printStackTrace();
            return false;
        }
    }

    public ScreenController<? extends ScreenModel> getController() {
        return this;
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    @Override
    public void setLabel(String label) {
        this.label = label;
    }

    @Override
    public void setMessages(Vector<ScreenMessage> messages) {
        this.messages = messages;
    }

    @Override
    public void setMessages(ScreenMessage ... messages) {
        Vector<ScreenMessage> messageVector = new Vector<ScreenMessage>();
        for (ScreenMessage m : messages) {
            messageVector.add(m);
        }
        this.messages = messageVector;
    }

    @Override
    public Vector<ScreenMessage> getMessages() {
        return this.messages;
    }

    @Override
    public void setController(ScreenController<? extends ScreenModel> controller) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setSelected(String viewid) {
        this.selected = viewid;
    }

    @Override
    public ScreenModel getSelected() {
        if (this.getChildren().size() > 0) {
            if (this.get(this.selected) == null) {
                return ((ScreenController)this.getChildren().firstElement()).getModel();
            }
            return ((ScreenController)this.get(this.selected)).getModel();
        }
        return null;
    }

    @Override
    public abstract String getViewTemplate();

    public abstract String getViewName();

    @Override
    public abstract void reload(Database var1);

    @Override
    public void reset() {
    }

    @Deprecated
    public ScreenController<?> getScreen() {
        return this.getController();
    }

    @Deprecated
    public ApplicationController getRootScreen() {
        return this.getApplicationController();
    }

    @Override
    public void setSuccess(String message) {
        this.setMessages(new ScreenMessage(message, true));
    }

    @Override
    public void setError(String message) {
        this.setMessages(new ScreenMessage(message, false));
    }
}

