/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.framework.ui;

import freemarker.cache.ClassTemplateLoader;
import freemarker.cache.FileTemplateLoader;
import freemarker.cache.MultiTemplateLoader;
import freemarker.cache.TemplateLoader;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import freemarker.template.TemplateExceptionHandler;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.molgenis.framework.ui.ApplicationModel;
import org.molgenis.framework.ui.MolgenisOriginalStyle;
import org.molgenis.framework.ui.ScreenModel;
import org.molgenis.framework.ui.SimpleScreenView;
import org.molgenis.framework.ui.html.WidgetFactory;

public class FreemarkerView
extends SimpleScreenView<ScreenModel> {
    private Configuration conf = null;
    private String templatePath;
    private static final Logger logger = Logger.getLogger(FreemarkerView.class);
    private Map<String, Object> arguments = new LinkedHashMap<String, Object>();

    public FreemarkerView(String templatePath, ScreenModel model) {
        super(model);
        this.templatePath = templatePath;
    }

    public FreemarkerView(Class<?> klazz, Map<String, Object> templateArgs) {
        this(klazz.getCanonicalName().replace(".", "/") + ".ftl", templateArgs);
    }

    public FreemarkerView(String templatePath, Map<String, Object> templateArgs) {
        super(null);
        this.templatePath = templatePath;
        this.arguments = templateArgs;
    }

    public FreemarkerView() {
        super(null);
    }

    public String render(String templatePath, Map<String, Object> templateArgs) {
        logger.debug((Object)("trying to render " + templatePath));
        try {
            if (this.conf == null) {
                logger.debug((Object)"create freemarker config");
                this.conf = new Configuration();
                this.conf.setTemplateExceptionHandler(TemplateExceptionHandler.RETHROW_HANDLER);
                ArrayList<Object> loaders = new ArrayList<Object>();
                loaders.add(new ClassTemplateLoader(MolgenisOriginalStyle.class, ""));
                loaders.add(new ClassTemplateLoader());
                for (Map.Entry<String, Object> entry : templateArgs.entrySet()) {
                    Object value = entry.getValue();
                    if (entry.getKey() == null || !entry.getKey().equals("model") || value == null) continue;
                    loaders.add(new ClassTemplateLoader(value.getClass()));
                    loaders.add(new ClassTemplateLoader(value.getClass().getSuperclass()));
                }
                loaders.add(new FileTemplateLoader());
                loaders.add(new FileTemplateLoader(new File("/")));
                MultiTemplateLoader mLoader = new MultiTemplateLoader(loaders.toArray(new TemplateLoader[loaders.size()]));
                this.conf.setTemplateLoader((TemplateLoader)mLoader);
                logger.debug((Object)"created freemarker config");
            }
            this.conf.addAutoInclude("ScreenViewHelper.ftl");
            WidgetFactory.configure(this.conf);
            Template template = this.conf.getTemplate(templatePath);
            StringWriter writer = new StringWriter();
            template.process(templateArgs, (Writer)writer);
            writer.close();
            return writer.toString();
        }
        catch (TemplateException e) {
            logger.error((Object)("rendering of template " + templatePath + " failed:"));
            e.printStackTrace();
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter((Writer)sw, true);
            e.printStackTrace(pw);
            pw.flush();
            sw.flush();
            return sw.toString().replace("\n", "<br/>");
        }
        catch (IOException e) {
            logger.error((Object)("rendering of template " + templatePath + " failed:"));
            e.printStackTrace();
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter((Writer)sw, true);
            e.printStackTrace(pw);
            pw.flush();
            sw.flush();
            return sw.toString().replace("\n", "<br/>");
        }
    }

    @Override
    public String render() {
        LinkedHashMap<String, Object> templateArgs = new LinkedHashMap<String, Object>(this.arguments);
        if (this.model != null) {
            templateArgs.put("application", this.model.getController().getApplicationController().getModel());
            templateArgs.put("show", ((ApplicationModel)this.model.getController().getApplicationController().getModel()).getShow());
        }
        templateArgs.put("screen", this.model);
        templateArgs.put("model", this.model);
        templateArgs.put("widgetfactory", new WidgetFactory());
        templateArgs.put("typefield", "__Type");
        return this.render(this.templatePath, templateArgs);
    }

    @Override
    public String getCustomHtmlHeaders() {
        return this.model.getController().getCustomHtmlHeaders();
    }

    public String getTemplatePath() {
        return this.templatePath;
    }

    public void setTemplatePath(String templatePath) {
        this.templatePath = templatePath;
    }

    public void addParameter(String name, Object value) {
        this.arguments.put(name, value);
    }
}

