/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.framework.tupletable.view.renderers;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.molgenis.MolgenisFieldTypes;
import org.molgenis.fieldtypes.CategoricalField;
import org.molgenis.fieldtypes.FieldType;
import org.molgenis.framework.tupletable.TableException;
import org.molgenis.framework.tupletable.TupleTable;
import org.molgenis.framework.tupletable.view.renderers.CsvExporter;
import org.molgenis.model.elements.Field;

@SuppressWarnings(value={"VA_FORMAT_STRING_USES_NEWLINE"}, justification="Always use \n for newlines")
public class SPSSExporter
extends CsvExporter {
    public SPSSExporter(TupleTable matrix) {
        super(matrix);
    }

    public void export(OutputStream csvOs, OutputStream spssOs, String csvFileName) throws IOException, TableException {
        super.export(csvOs);
        this.writeSPSFile(spssOs, csvFileName);
    }

    private void writeSPSFile(OutputStream spssOs, String csvFileName) throws TableException, UnsupportedEncodingException {
        BufferedWriter spsWriter = new BufferedWriter(new OutputStreamWriter(spssOs, "UTF8"));
        List<Field> columns = this.tupleTable.getColumns();
        StringWriter valLabels = new StringWriter();
        StringWriter colNames = new StringWriter();
        ArrayList<Field> categoricalFields = new ArrayList<Field>();
        for (Field field : columns) {
            FieldType fieldType = field.getType();
            if (fieldType.getEnumType() == MolgenisFieldTypes.FieldTypeEnum.CATEGORICAL) {
                categoricalFields.add(field);
            }
            colNames.write(String.format("%s %s ", field.getName(), SPSSExporter.colTypeToSPSSType(fieldType.getEnumType())));
        }
        for (Field field : categoricalFields) {
            Map<String, String> categoryMapping = ((CategoricalField)field.getType()).getCategoryMapping();
            valLabels.write(String.format("ADD VALUE LABELS %s ", field.getName()));
            for (Map.Entry<String, String> entry : categoryMapping.entrySet()) {
                valLabels.write(String.format(" %s '%s' ", entry.getKey(), entry.getValue()));
            }
            valLabels.write("\n");
        }
        try {
            String spsFormatStr = String.format("GET DATA\n/type = txt\n/file = '%s'\n /qualifier = '\"'\n/delimiters = '\\t'\n/firstcase = 2\n/variables = %s.\n/execute.", csvFileName, colNames.toString() + valLabels.toString());
            spsWriter.write(spsFormatStr);
            spsWriter.flush();
            spsWriter.close();
        }
        catch (IOException e) {
            throw new TableException(e);
        }
    }

    private static String colTypeToSPSSType(MolgenisFieldTypes.FieldTypeEnum columnType) {
        switch (columnType) {
            case CATEGORICAL: {
                return "F";
            }
            case DATE: {
                return "ADATE";
            }
            case DATE_TIME: {
                return "ADATE";
            }
            case DECIMAL: {
                return "F";
            }
            case INT: {
                return "F";
            }
            case STRING: {
                return "A";
            }
        }
        throw new IllegalArgumentException("Unknown field type: " + (Object)((Object)columnType));
    }
}

