/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.framework.tupletable.view.renderers;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;
import javax.annotation.Nullable;
import org.apache.commons.io.IOUtils;
import org.molgenis.framework.tupletable.TableException;
import org.molgenis.framework.tupletable.TupleTable;
import org.molgenis.framework.tupletable.view.renderers.AbstractExporter;
import org.molgenis.io.TupleWriter;
import org.molgenis.io.excel.ExcelWriter;
import org.molgenis.model.elements.Field;
import org.molgenis.util.tuple.Tuple;

public class ExcelExporter
extends AbstractExporter {
    public ExcelExporter(TupleTable tableTable) {
        super(tableTable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void export(OutputStream os) throws TableException {
        ExcelWriter excelWriter = new ExcelWriter(os);
        try {
            int colOffset = this.tupleTable.getColOffset();
            int colLimit = this.tupleTable.getColLimit();
            int rowOffset = this.tupleTable.getOffset();
            int rowLimit = this.tupleTable.getLimit();
            this.tupleTable.setColOffset(0);
            this.tupleTable.setColLimit(0);
            this.tupleTable.setOffset(0);
            this.tupleTable.setLimit(0);
            TupleWriter tupleWriter = excelWriter.createTupleWriter("Sheet1");
            try {
                tupleWriter.writeColNames(Iterables.transform(this.tupleTable.getColumns(), (Function)new Function<Field, String>(){

                    @Nullable
                    public String apply(@Nullable Field field) {
                        return field != null ? field.getName() : null;
                    }
                }));
                Iterator<Tuple> it = this.tupleTable.iterator();
                while (it.hasNext()) {
                    tupleWriter.write(it.next());
                }
            }
            finally {
                IOUtils.closeQuietly((Closeable)tupleWriter);
                this.tupleTable.setColOffset(colOffset);
                this.tupleTable.setColLimit(colLimit);
                this.tupleTable.setOffset(rowOffset);
                this.tupleTable.setLimit(rowLimit);
            }
        }
        catch (IOException e) {
            throw new TableException(e);
        }
        finally {
            IOUtils.closeQuietly((Closeable)excelWriter);
        }
    }
}

